% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gaussian_Inference.r
\name{dPosteriorPredictive.GaussianNIW}
\alias{dPosteriorPredictive.GaussianNIW}
\title{Posterior predictive density function of a "GaussianNIW" object}
\usage{
\method{dPosteriorPredictive}{GaussianNIW}(obj, x, LOG = TRUE, ...)
}
\arguments{
\item{obj}{A "GaussianNIW" object.}

\item{x}{matrix, or the ones that can be converted to matrix, each row of x is an observation.}

\item{LOG}{Return the log density if set to "TRUE".}

\item{...}{Additional arguments to be passed to other inherited types.}
}
\value{
A numeric vector of the same length as nrow(x), the posterior predictive density.
}
\description{
Generate the the density value of the posterior predictive distribution of the following structure:
     \deqn{mu,Sigma|m,k,v,S \sim NIW(m,k,v,S)}
     \deqn{x|mu,Sigma \sim Gaussian(mu,Sigma)}
Where NIW() is the Normal-Inverse-Wishart distribution, Gaussian() is the Gaussian distribution. See \code{?dNIW} and \code{dGaussian} for the definitions of these distribution.\cr
The model structure and prior parameters are stored in a "GaussianNIW" object. \cr
Posterior predictive density is p(x|m,k,v,S).
}
\examples{
x <- rGaussian(1000,mu = c(1,1),Sigma = matrix(c(1,0.5,0.5,3),2,2))
obj <- GaussianNIW(gamma=list(m=c(0,0),k=1,v=2,S=diag(2)))
## out1 and out2 it should have the same values:
out1 <- dPosteriorPredictive(obj = obj, x = x,LOG = TRUE)
out2 <- numeric(nrow(x))
for(i in 1:nrow(x))
out2[i] <- marginalLikelihood(obj,x=x[i,,drop=FALSE],LOG = TRUE)
max(abs(out1-out2))
}
\references{
Murphy, Kevin P. "Conjugate Bayesian analysis of the Gaussian distribution." def 1.22 (2007): 16.

Gelman, Andrew, et al. "Bayesian Data Analysis Chapman & Hall." CRC Texts in Statistical Science (2004).
}
\seealso{
\code{\link{GaussianNIW}}, \code{\link{dPosteriorPredictive.GaussianNIW}}, \code{\link{marginalLikelihood.GaussianNIW}}
}
