% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gamma_Inference.r
\name{rWishart}
\alias{rWishart}
\title{Random generation for Wishart distribution}
\usage{
rWishart(df, rate = NULL, scale = NULL)
}
\arguments{
\item{df}{numeric, the degree of freedom.}

\item{rate}{matrix, a symmetric positive-definite matrix, the 'rate', or 'inverse-scale' parameter. The 'rate' parameter in Wishart is the 'scale' parameter in InvWishart}

\item{scale, }{matrix, the inverse of rate. Only one of 'rate' and 'scale' should be non-NULL.}
}
\value{
A symmetric positive-definite matrix.
}
\description{
Generate random samples from Wishart distribution. For a random matrix x, the density function of Wishart distribution is defined as:
    \deqn{(2^{(df p)/2} Gamma_p(df/2) |rate|^{-df/2})^{-1} |x|^{(df-p-1)/2} exp(-1/2 tr(x rate))}
Where x is a pxp symmetric positive definite matrix, Gamma_p() is the multivariate Gamma function of dimension p.
}
\examples{
rate <- crossprod(matrix(rnorm(15),5,3)) #the prior inverse-scale
m <- matrix(0,3,3)
## get 1000 samples and calculate the sample mean
for(i in 1:100){
    m <- m+rWishart(df=5,rate=rate)/100
}
## m should roughly equal to df*inverse(rate):
m
pdsInverse(rate)*5
## try generating samples with 'rate' parameter:
scale <- pdsInverse(rate)
m2 <- matrix(0,3,3)
for(i in 1:100){
    m2 <- m2+rWishart(df=5,scale=scale)/100
}
## m2 should roughly equal df*scale:
m2
5*scale
}
\references{
Smith, W. B., and R. R. Hocking. "Algorithm as 53: Wishart variate generator." Journal of the Royal Statistical Society. Series C (Applied Statistics) 21.3 (1972): 341-345.
}
