## Julia Bischof
## 10-09-2015

readIMGT<-function(data,filterNoResults=TRUE){
  if(substr(strsplit(data,split="/")[[1]][length(strsplit(data,split="/")[[1]])],1,2) %in% c("3_","6_")){
    newcolnames<-gsub(" |-","_",strsplit(readLines(data)[1],split="\t")[[1]])
    newcolnames<-gsub("'","",newcolnames)
    tab<-data.frame(matrix(NA, nrow=0,ncol=length(newcolnames)))
    tab<-rbind(tab,read.table(data,fill=TRUE,header=F,skip=1,sep="\t",as.is=TRUE))
    colnames(tab)<-newcolnames
  }else{
    tab<-read.table(data,fill=TRUE,header=TRUE,sep="\t",as.is=TRUE,check.names=F)
    colnames(tab)<-gsub(" |-","_",gsub("'","",colnames(tab)))
  }
  tab<-tab[,-ncol(tab)]
  if(filterNoResults==T){
    out<-grep("No results",tab[,3])
    if(length(out)>0){
      tab<-tab[-out,]
      cat("...", length(out), "sequences were excluded\n")
    }else{
      cat("... no sequences were excluded\n")
    }      
  }
  return(tab)
}


