% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raster_by_poly.R
\name{summarize_raster_list}
\alias{summarize_raster_list}
\title{Summarize a list of rasters into a list of numeric vectors}
\usage{
summarize_raster_list(
  raster_list,
  parallel = FALSE,
  future_strategy = NULL,
  workers = NULL,
  ...
)
}
\arguments{
\item{raster_list}{list of rasters}

\item{parallel}{process in parallel? Default \code{FALSE}.}

\item{future_strategy}{the strategy to use in \code{\link[future:plan]{future::plan()}} for parallel
computation. Default \code{NULL} respects if user has already set a plan using
\code{\link[future:plan]{future::plan()}} or an \link[future:future.options]{option},
otherwise uses \code{"multiprocess"}.}

\item{workers}{number of workers if doing parallel. Default \code{NULL} uses the
default of the future strategy chosen (usually \code{\link[future:availableCores]{future::availableCores()}}).}

\item{...}{passed on to \code{\link[future:plan]{future::plan()}}}
}
\value{
a list of numeric vectors
}
\description{
Summarize a list of rasters into a list of numeric vectors
}
