# Copyright 2023 Province of British Columbia
  #
  # Licensed under the Apache License, Version 2.0 (the "License");
  # you may not use this file except in compliance with the License.
  # You may obtain a copy of the License at
  #
  # http://www.apache.org/licenses/LICENSE-2.0
  #
  # Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an "AS IS" BASIS,
  # WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  # See the License for the specific language governing permissions and limitations under the License.
  
#############################################################
# This file is automatically generated by running the function
# bcmaps:::make_shortcuts(). Do not edit by hand.
#############################################################

#' British Columbia Air Zones
#'
#'
#' @inheritParams bc_bound_hres
#'
#' @return The spatial layer of `airzones` in the desired class
#'
#' @source `bcdata::bcdc_get_data(record = 'e8eeefc4-2826-47bc-8430-85703d328516', resource = 'c495d082-b586-4df0-9e06-bd6b66a8acd9')`
#'
#' 
#'
#' @examples
#' \dontrun{
#' my_layer <- airzones()
#' }
#'
#' @export
airzones <- function(class = deprecated(), ask = interactive(), force = FALSE) {

   if (lifecycle::is_present(class)) {
     deprecate_sp('bcmaps::airzones(class)')
     class <- match.arg(class, choices = c('sf', 'sp'))
   }

   get_layer('airzones', class = class, ask = ask, force = force)
}

#' BC Major Cities Points
#'
#'
#' @inheritParams bc_bound_hres
#'
#' @return The spatial layer of `bc_cities` in the desired class
#'
#' @source `bcdata::bcdc_get_data(record = 'b678c432-c5c1-4341-88db-0d6befa0c7f8', resource = '443dd858-2e37-4a8f-937a-f53359f16e64')`
#'
#' 
#'
#' @examples
#' \dontrun{
#' my_layer <- bc_cities()
#' }
#'
#' @export
bc_cities <- function(class = deprecated(), ask = interactive(), force = FALSE) {

   if (lifecycle::is_present(class)) {
     deprecate_sp('bcmaps::bc_cities(class)')
     class <- match.arg(class, choices = c('sf', 'sp'))
   }

   get_layer('bc_cities', class = class, ask = ask, force = force)
}

#' British Columbia BEC Map
#'
#'
#' @inheritParams bc_bound_hres
#'
#' @return The spatial layer of `bec` in the desired class
#'
#' @source `bcdata::bcdc_get_data(record = 'f358a53b-ffde-4830-a325-a5a03ff672c3', resource = '3ec24cb4-f78d-48a9-87e7-516763f00cc8')`
#'
#' 
#'
#' @examples
#' \dontrun{
#' my_layer <- bec()
#' }
#'
#' @export
bec <- function(class = deprecated(), ask = interactive(), force = FALSE) {

   if (lifecycle::is_present(class)) {
     deprecate_sp('bcmaps::bec(class)')
     class <- match.arg(class, choices = c('sf', 'sp'))
   }

   get_layer('bec', class = class, ask = ask, force = force)
}

#' Current Census Dissemination Areas
#'
#'
#' @inheritParams bc_bound_hres
#'
#' @return The spatial layer of `census_dissemination_area` in the desired class
#'
#' @source `bcdata::bcdc_get_data(record = 'a091fd65-d682-4a24-8c0e-68de7c87e3a3', resource = 'a7fa66d4-0f95-4c58-861d-42d875e5b79f')`
#'
#' 
#'
#' @examples
#' \dontrun{
#' my_layer <- census_dissemination_area()
#' }
#'
#' @export
census_dissemination_area <- function(class = deprecated(), ask = interactive(), force = FALSE) {

   if (lifecycle::is_present(class)) {
     deprecate_sp('bcmaps::census_dissemination_area(class)')
     class <- match.arg(class, choices = c('sf', 'sp'))
   }

   get_layer('census_dissemination_area', class = class, ask = ask, force = force)
}

#' Current Census Division Boundaries
#'
#'
#' @inheritParams bc_bound_hres
#'
#' @return The spatial layer of `census_division` in the desired class
#'
#' @source `bcdata::bcdc_get_data(record = 'ef17918a-597a-4012-8534-f8e71d8735b3', resource = '36b530c2-1de6-44a2-a6f6-c1fce36c53ed')`
#'
#' 
#'
#' @examples
#' \dontrun{
#' my_layer <- census_division()
#' }
#'
#' @export
census_division <- function(class = deprecated(), ask = interactive(), force = FALSE) {

   if (lifecycle::is_present(class)) {
     deprecate_sp('bcmaps::census_division(class)')
     class <- match.arg(class, choices = c('sf', 'sp'))
   }

   get_layer('census_division', class = class, ask = ask, force = force)
}

#' Current Census Economic Region Boundaries
#'
#'
#' @inheritParams bc_bound_hres
#'
#' @return The spatial layer of `census_economic` in the desired class
#'
#' @source `bcdata::bcdc_get_data(record = '1aebc451-a41c-496f-8b18-6f414cde93b7', resource = '3f0236cf-b1a1-4f1a-8e9e-86c2c3daff96')`
#'
#' 
#'
#' @examples
#' \dontrun{
#' my_layer <- census_economic()
#' }
#'
#' @export
census_economic <- function(class = deprecated(), ask = interactive(), force = FALSE) {

   if (lifecycle::is_present(class)) {
     deprecate_sp('bcmaps::census_economic(class)')
     class <- match.arg(class, choices = c('sf', 'sp'))
   }

   get_layer('census_economic', class = class, ask = ask, force = force)
}

#' Current Census Metropolitan Areas
#'
#'
#' @inheritParams bc_bound_hres
#'
#' @return The spatial layer of `census_metropolitan_area` in the desired class
#'
#' @source `bcdata::bcdc_get_data(record = 'a6fb34b7-0937-4718-8f1f-43dba2c0f407', resource = 'f129a965-363e-4d7e-8319-a4010e002fdb')`
#'
#' 
#'
#' @examples
#' \dontrun{
#' my_layer <- census_metropolitan_area()
#' }
#'
#' @export
census_metropolitan_area <- function(class = deprecated(), ask = interactive(), force = FALSE) {

   if (lifecycle::is_present(class)) {
     deprecate_sp('bcmaps::census_metropolitan_area(class)')
     class <- match.arg(class, choices = c('sf', 'sp'))
   }

   get_layer('census_metropolitan_area', class = class, ask = ask, force = force)
}

#' Current Census Subdivision Boundaries
#'
#'
#' @inheritParams bc_bound_hres
#'
#' @return The spatial layer of `census_subdivision` in the desired class
#'
#' @source `bcdata::bcdc_get_data(record = '4c5618c6-38dd-4a62-a3de-9408b4974bb6', resource = '98bd1222-57bb-4504-92c2-4a5857ae7671')`
#'
#' 
#'
#' @examples
#' \dontrun{
#' my_layer <- census_subdivision()
#' }
#'
#' @export
census_subdivision <- function(class = deprecated(), ask = interactive(), force = FALSE) {

   if (lifecycle::is_present(class)) {
     deprecate_sp('bcmaps::census_subdivision(class)')
     class <- match.arg(class, choices = c('sf', 'sp'))
   }

   get_layer('census_subdivision', class = class, ask = ask, force = force)
}

#' Current Census Tract Boundaries
#'
#'
#' @inheritParams bc_bound_hres
#'
#' @return The spatial layer of `census_tract` in the desired class
#'
#' @source `bcdata::bcdc_get_data(record = '539aae5b-12f6-4934-9592-9b27acc827f8', resource = 'be767db6-0d4e-4906-a89b-564637f14db9')`
#'
#' 
#'
#' @examples
#' \dontrun{
#' my_layer <- census_tract()
#' }
#'
#' @export
census_tract <- function(class = deprecated(), ask = interactive(), force = FALSE) {

   if (lifecycle::is_present(class)) {
     deprecate_sp('bcmaps::census_tract(class)')
     class <- match.arg(class, choices = c('sf', 'sp'))
   }

   get_layer('census_tract', class = class, ask = ask, force = force)
}

#' British Columbia Ecoprovinces
#'
#'
#' @inheritParams bc_bound_hres
#'
#' @return The spatial layer of `ecoprovinces` in the desired class
#'
#' @source `bcdata::bcdc_get_data(record = '51832f47-efdf-4956-837a-45fc2c9032dd', resource = '811fcedb-1a53-4574-8149-454f4a740682')`
#'
#' 
#'
#' @examples
#' \dontrun{
#' my_layer <- ecoprovinces()
#' }
#'
#' @export
ecoprovinces <- function(class = deprecated(), ask = interactive(), force = FALSE) {

   if (lifecycle::is_present(class)) {
     deprecate_sp('bcmaps::ecoprovinces(class)')
     class <- match.arg(class, choices = c('sf', 'sp'))
   }

   get_layer('ecoprovinces', class = class, ask = ask, force = force)
}

#' British Columbia Ecoregions
#'
#'
#' @inheritParams bc_bound_hres
#'
#' @return The spatial layer of `ecoregions` in the desired class
#'
#' @source `bcdata::bcdc_get_data(record = 'd00389e0-66da-4895-bd56-39a0dd64aa78', resource = 'bd816a86-4f5e-4989-b1df-0b2f3f4a5f86')`
#'
#' 
#'
#' @examples
#' \dontrun{
#' my_layer <- ecoregions()
#' }
#'
#' @export
ecoregions <- function(class = deprecated(), ask = interactive(), force = FALSE) {

   if (lifecycle::is_present(class)) {
     deprecate_sp('bcmaps::ecoregions(class)')
     class <- match.arg(class, choices = c('sf', 'sp'))
   }

   get_layer('ecoregions', class = class, ask = ask, force = force)
}

#' British Columbia Ecosections
#'
#'
#' @inheritParams bc_bound_hres
#'
#' @return The spatial layer of `ecosections` in the desired class
#'
#' @source `bcdata::bcdc_get_data(record = 'ccc01f43-860d-4583-8ba4-e72d8379441e', resource = '6b6a3122-7a0b-4c0f-a72b-1e5c0e13d7e6')`
#'
#' 
#'
#' @examples
#' \dontrun{
#' my_layer <- ecosections()
#' }
#'
#' @export
ecosections <- function(class = deprecated(), ask = interactive(), force = FALSE) {

   if (lifecycle::is_present(class)) {
     deprecate_sp('bcmaps::ecosections(class)')
     class <- match.arg(class, choices = c('sf', 'sp'))
   }

   get_layer('ecosections', class = class, ask = ask, force = force)
}

#' British Columbia's developed ground water aquifers
#'
#'
#' @inheritParams bc_bound_hres
#'
#' @return The spatial layer of `gw_aquifers` in the desired class
#'
#' @source `bcdata::bcdc_get_data(record = '099d69c5-1401-484d-9e19-c121ccb7977c', resource = '8f421e3a-ccd3-4fab-8198-53ad6e9e2af2')`
#'
#' 
#'
#' @examples
#' \dontrun{
#' my_layer <- gw_aquifers()
#' }
#'
#' @export
gw_aquifers <- function(class = deprecated(), ask = interactive(), force = FALSE) {

   if (lifecycle::is_present(class)) {
     deprecate_sp('bcmaps::gw_aquifers(class)')
     class <- match.arg(class, choices = c('sf', 'sp'))
   }

   get_layer('gw_aquifers', class = class, ask = ask, force = force)
}

#' Community Health Service Areas - CHSA
#'
#'
#' @inheritParams bc_bound_hres
#'
#' @return The spatial layer of `health_chsa` in the desired class
#'
#' @source `bcdata::bcdc_get_data(record = '68f2f577-28a7-46b4-bca9-7e9770f2f357', resource = '59065b51-511a-4976-b77f-034168365273')`
#'
#' 
#'
#' @examples
#' \dontrun{
#' my_layer <- health_chsa()
#' }
#'
#' @export
health_chsa <- function(class = deprecated(), ask = interactive(), force = FALSE) {

   if (lifecycle::is_present(class)) {
     deprecate_sp('bcmaps::health_chsa(class)')
     class <- match.arg(class, choices = c('sf', 'sp'))
   }

   get_layer('health_chsa', class = class, ask = ask, force = force)
}

#' Health Authority Boundaries
#'
#'
#' @inheritParams bc_bound_hres
#'
#' @return The spatial layer of `health_ha` in the desired class
#'
#' @source `bcdata::bcdc_get_data(record = '7bc6018f-bb4f-4e5d-845e-c529e3d1ac3b', resource = '93b79a3c-2da4-4fd4-b953-2f5c690db430')`
#'
#' 
#'
#' @examples
#' \dontrun{
#' my_layer <- health_ha()
#' }
#'
#' @export
health_ha <- function(class = deprecated(), ask = interactive(), force = FALSE) {

   if (lifecycle::is_present(class)) {
     deprecate_sp('bcmaps::health_ha(class)')
     class <- match.arg(class, choices = c('sf', 'sp'))
   }

   get_layer('health_ha', class = class, ask = ask, force = force)
}

#' Health Service Delivery Area Boundaries
#'
#'
#' @inheritParams bc_bound_hres
#'
#' @return The spatial layer of `health_hsda` in the desired class
#'
#' @source `bcdata::bcdc_get_data(record = '71c930b9-563a-46da-a10f-ead49ccbc390', resource = 'c5dad467-229b-4378-852b-ff92479a65b6')`
#'
#' 
#'
#' @examples
#' \dontrun{
#' my_layer <- health_hsda()
#' }
#'
#' @export
health_hsda <- function(class = deprecated(), ask = interactive(), force = FALSE) {

   if (lifecycle::is_present(class)) {
     deprecate_sp('bcmaps::health_hsda(class)')
     class <- match.arg(class, choices = c('sf', 'sp'))
   }

   get_layer('health_hsda', class = class, ask = ask, force = force)
}

#' Local Health Area Boundaries
#'
#'
#' @inheritParams bc_bound_hres
#'
#' @return The spatial layer of `health_lha` in the desired class
#'
#' @source `bcdata::bcdc_get_data(record = 'afd021d9-7722-4410-b506-d394c66e74fc', resource = 'd6e951d3-5103-475a-8bb6-b4d275e6343f')`
#'
#' 
#'
#' @examples
#' \dontrun{
#' my_layer <- health_lha()
#' }
#'
#' @export
health_lha <- function(class = deprecated(), ask = interactive(), force = FALSE) {

   if (lifecycle::is_present(class)) {
     deprecate_sp('bcmaps::health_lha(class)')
     class <- match.arg(class, choices = c('sf', 'sp'))
   }

   get_layer('health_lha', class = class, ask = ask, force = force)
}

#' Hydrologic Zone Boundaries of British Columbia
#'
#'
#' @inheritParams bc_bound_hres
#'
#' @return The spatial layer of `hydrozones` in the desired class
#'
#' @source `bcdata::bcdc_get_data(record = '329fd234-8835-4d44-9aaa-97c37bfc8d92', resource = 'baeb665e-85c7-4a7b-8e67-8b956785490a')`
#'
#' 
#'
#' @examples
#' \dontrun{
#' my_layer <- hydrozones()
#' }
#'
#' @export
hydrozones <- function(class = deprecated(), ask = interactive(), force = FALSE) {

   if (lifecycle::is_present(class)) {
     deprecate_sp('bcmaps::hydrozones(class)')
     class <- match.arg(class, choices = c('sf', 'sp'))
   }

   get_layer('hydrozones', class = class, ask = ask, force = force)
}

#' British Columbia Municipalities
#'
#'
#' @inheritParams bc_bound_hres
#'
#' @return The spatial layer of `municipalities` in the desired class
#'
#' @source `bcdata::bcdc_get_data(record = 'e3c3c580-996a-4668-8bc5-6aa7c7dc4932', resource = '25c95b07-5882-47ff-970d-36cb243b8355')`
#'
#' @seealso [combine_nr_rd()] to combine Regional Districts and the Northern Rockies Regional Municipality into one layer
#'
#' @examples
#' \dontrun{
#' my_layer <- municipalities()
#' }
#'
#' @export
municipalities <- function(class = deprecated(), ask = interactive(), force = FALSE) {

   if (lifecycle::is_present(class)) {
     deprecate_sp('bcmaps::municipalities(class)')
     class <- match.arg(class, choices = c('sf', 'sp'))
   }

   get_layer('municipalities', class = class, ask = ask, force = force)
}

#' British Columbia Natural Resource (NR) Areas
#'
#'
#' @inheritParams bc_bound_hres
#'
#' @return The spatial layer of `nr_areas` in the desired class
#'
#' @source `bcdata::bcdc_get_data(record = 'c1861ba4-abb8-4947-b3e5-7f7c4d7257d5', resource = '4b317896-1a42-4c03-9dbd-bff996d5ea0c')`
#'
#' 
#'
#' @examples
#' \dontrun{
#' my_layer <- nr_areas()
#' }
#'
#' @export
nr_areas <- function(class = deprecated(), ask = interactive(), force = FALSE) {

   if (lifecycle::is_present(class)) {
     deprecate_sp('bcmaps::nr_areas(class)')
     class <- match.arg(class, choices = c('sf', 'sp'))
   }

   get_layer('nr_areas', class = class, ask = ask, force = force)
}

#' British Columbia Natural Resource (NR) Districts
#'
#'
#' @inheritParams bc_bound_hres
#'
#' @return The spatial layer of `nr_districts` in the desired class
#'
#' @source `bcdata::bcdc_get_data(record = '0bc73892-e41f-41d0-8d8e-828c16139337', resource = 'e6676e55-2a6f-4b2b-91ad-3caf291ac5d4')`
#'
#' 
#'
#' @examples
#' \dontrun{
#' my_layer <- nr_districts()
#' }
#'
#' @export
nr_districts <- function(class = deprecated(), ask = interactive(), force = FALSE) {

   if (lifecycle::is_present(class)) {
     deprecate_sp('bcmaps::nr_districts(class)')
     class <- match.arg(class, choices = c('sf', 'sp'))
   }

   get_layer('nr_districts', class = class, ask = ask, force = force)
}

#' British Columbia Natural Resource (NR) Regions
#'
#'
#' @inheritParams bc_bound_hres
#'
#' @return The spatial layer of `nr_regions` in the desired class
#'
#' @source `bcdata::bcdc_get_data(record = 'dfc492c0-69c5-4c20-a6de-2c9bc999301f', resource = 'ec636f64-9c5f-4704-8e66-2dd43032c9b5')`
#'
#' 
#'
#' @examples
#' \dontrun{
#' my_layer <- nr_regions()
#' }
#'
#' @export
nr_regions <- function(class = deprecated(), ask = interactive(), force = FALSE) {

   if (lifecycle::is_present(class)) {
     deprecate_sp('bcmaps::nr_regions(class)')
     class <- match.arg(class, choices = c('sf', 'sp'))
   }

   get_layer('nr_regions', class = class, ask = ask, force = force)
}

#' British Columbia Regional Districts
#'
#'
#' @inheritParams bc_bound_hres
#'
#' @return The spatial layer of `regional_districts` in the desired class
#'
#' @source `bcdata::bcdc_get_data(record = 'd1aff64e-dbfe-45a6-af97-582b7f6418b9', resource = '57c7f719-dc87-415c-8be7-ef2f95289397')`
#'
#' @seealso [combine_nr_rd()] to combine Regional Districts and the Northern Rockies Regional Municipality into one layer
#'
#' @examples
#' \dontrun{
#' my_layer <- regional_districts()
#' }
#'
#' @export
regional_districts <- function(class = deprecated(), ask = interactive(), force = FALSE) {

   if (lifecycle::is_present(class)) {
     deprecate_sp('bcmaps::regional_districts(class)')
     class <- match.arg(class, choices = c('sf', 'sp'))
   }

   get_layer('regional_districts', class = class, ask = ask, force = force)
}

#' British Columbia Timber Supply Areas and TSA Blocks
#'
#'
#' @inheritParams bc_bound_hres
#'
#' @return The spatial layer of `tsa` in the desired class
#'
#' @source `bcdata::bcdc_get_data(record = '8daa29da-d7f4-401c-83ae-d962e3a28980', resource = '6851f8a6-77b9-4555-9f60-3d2bd8e039be')`
#'
#' 
#'
#' @examples
#' \dontrun{
#' my_layer <- tsa()
#' }
#'
#' @export
tsa <- function(class = deprecated(), ask = interactive(), force = FALSE) {

   if (lifecycle::is_present(class)) {
     deprecate_sp('bcmaps::tsa(class)')
     class <- match.arg(class, choices = c('sf', 'sp'))
   }

   get_layer('tsa', class = class, ask = ask, force = force)
}

#' British Columbia's Water Management Districts
#'
#'
#' @inheritParams bc_bound_hres
#'
#' @return The spatial layer of `water_districts` in the desired class
#'
#' @source `bcdata::bcdc_get_data(record = '92cb3ad8-9582-48a9-9e79-9a9d33601e50', resource = '07f9aa3f-0b66-4a49-919f-332d12bcd8f0')`
#'
#' 
#'
#' @examples
#' \dontrun{
#' my_layer <- water_districts()
#' }
#'
#' @export
water_districts <- function(class = deprecated(), ask = interactive(), force = FALSE) {

   if (lifecycle::is_present(class)) {
     deprecate_sp('bcmaps::water_districts(class)')
     class <- match.arg(class, choices = c('sf', 'sp'))
   }

   get_layer('water_districts', class = class, ask = ask, force = force)
}

#' British Columbia's Water Management Precincts
#'
#'
#' @inheritParams bc_bound_hres
#'
#' @return The spatial layer of `water_precincts` in the desired class
#'
#' @source `bcdata::bcdc_get_data(record = 'b5f436b4-532c-4ee2-ba27-90d55ec8c73f', resource = 'e482fd4a-be58-4541-8e0d-c39a764fd0a3')`
#'
#' 
#'
#' @examples
#' \dontrun{
#' my_layer <- water_precincts()
#' }
#'
#' @export
water_precincts <- function(class = deprecated(), ask = interactive(), force = FALSE) {

   if (lifecycle::is_present(class)) {
     deprecate_sp('bcmaps::water_precincts(class)')
     class <- match.arg(class, choices = c('sf', 'sp'))
   }

   get_layer('water_precincts', class = class, ask = ask, force = force)
}

#' Water Survey of Canada Sub-Sub-Drainage Areas
#'
#'
#' @inheritParams bc_bound_hres
#'
#' @return The spatial layer of `wsc_drainages` in the desired class
#'
#' @source `bcdata::bcdc_get_data(record = '7ae18a3c-917b-4cb1-9aa8-51a172475dbb', resource = '4455072e-d33b-4685-9edd-cffda763dd45')`
#'
#' 
#'
#' @examples
#' \dontrun{
#' my_layer <- wsc_drainages()
#' }
#'
#' @export
wsc_drainages <- function(class = deprecated(), ask = interactive(), force = FALSE) {

   if (lifecycle::is_present(class)) {
     deprecate_sp('bcmaps::wsc_drainages(class)')
     class <- match.arg(class, choices = c('sf', 'sp'))
   }

   get_layer('wsc_drainages', class = class, ask = ask, force = force)
}
