% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_map.R
\name{generate_map}
\alias{generate_map}
\title{Generate quick map}
\usage{
generate_map(varId, year, unitLevel = 2, unitParentId = NULL,
  aggregateId = NULL, lang = c("pl", "en"), ...)
}
\arguments{
\item{varId}{A single variable Id.
Use \code{\link{search_variables}} or \code{\link{get_variables}} to find variable id code.}

\item{year}{A single year from 2010-2018 range.}

\item{unitLevel}{A map and data NUTS level - number from 1 to 6. Use \code{\link{get_levels}} to find more info.}

\item{unitParentId}{A 12 character NUTS id code of interested unit. Use \code{\link{search_units}} or
\code{\link{get_units}} to find unit id code.}

\item{aggregateId}{An aggregate id. Use \code{\link{get_aggregates}} for more info.}

\item{lang}{A language of returned data, "pl" (default), "en"}

\item{...}{Other arguments passed on to \code{\link[httr]{GET}}. For example
a proxy parameters, see details.}
}
\value{
A tmap map.
}
\description{
Generate given NUTS level map with data from given variable
}
\details{
Generate quickly map for given NUTS level, using BDL data. Default level is 2.
  
  Maps available for year: 2010-2018
  
  Provide unit parent id to narrow the map for specific regions.
  
  Generating lower (levels 5 and 6) level maps can take some time.
  
  This function requires external map data "bdl.maps" loaded to global environment. 
  You can get data here:
  \href{https://github.com/statisticspoland/R_Package_to_API_BDL/releases/download/1.0.0/bdl.maps.RData}{Map 
  download}.
  Download data and double-click to load it to environment.

  To use a proxy to connect, a \code{\link[httr]{use_proxy}} can be
  passed to \code{\link[httr]{GET}}. For example
  \code{get_request(id, filters,
  config = httr::use_proxy(url, port, username, password))}.
}
\examples{
\donttest{
 generate_map(varId = "60559", year = "2017")
 }
}
