% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExtractorYtbid.R
\name{ExtractorYtbid}
\alias{ExtractorYtbid}
\title{Class to handle comments of YouTube files with ytbid extension}
\description{
This class inherits from the \code{\link{Instance}} class and
implements the functions of extracting the text and the date of an ytbid type file.
}
\section{Details}{

YouTube connection is handled through the \code{\link{Connections}} class
which loads the YouTube API credentials from the \emph{{bdpar.Options}} object.
Additionally, to increase the processing speed, each Youtube query is stored
in a cache to avoid the execution of duplicated queries. To enable this option,
cache location should be in the \strong{"cache.youtube.path"} field of
\emph{\link{bdpar.Options}} variable. This variable has to be the
path to store the comments and it is necessary that it has two folder named:
"_spam_" and "_ham_"
}

\section{Inherit}{

This class inherits from \code{\link{Instance}} and implements the
\code{obtainSource} and \code{obtainDate} abstracts functions.
}

\seealso{
\code{\link{bdpar.Options}}, \code{\link{Connections}},
         \code{\link{ExtractorEml}}, \code{\link{ExtractorSms}},
         \code{\link{ExtractorTwtid}}, \code{\link{Instance}}
}
\section{Super class}{
\code{\link[bdpar:Instance]{bdpar::Instance}} -> \code{ExtractorYtbid}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{ExtractorYtbid$new()}}
\item \href{#method-obtainId}{\code{ExtractorYtbid$obtainId()}}
\item \href{#method-getId}{\code{ExtractorYtbid$getId()}}
\item \href{#method-obtainDate}{\code{ExtractorYtbid$obtainDate()}}
\item \href{#method-obtainSource}{\code{ExtractorYtbid$obtainSource()}}
\item \href{#method-toString}{\code{ExtractorYtbid$toString()}}
\item \href{#method-clone}{\code{ExtractorYtbid$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="addBanPipes">}\href{../../bdpar/html/Instance.html#method-addBanPipes}{\code{bdpar::Instance$addBanPipes()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="addFlowPipes">}\href{../../bdpar/html/Instance.html#method-addFlowPipes}{\code{bdpar::Instance$addFlowPipes()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="addProperties">}\href{../../bdpar/html/Instance.html#method-addProperties}{\code{bdpar::Instance$addProperties()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="checkCompatibility">}\href{../../bdpar/html/Instance.html#method-checkCompatibility}{\code{bdpar::Instance$checkCompatibility()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="getBanPipes">}\href{../../bdpar/html/Instance.html#method-getBanPipes}{\code{bdpar::Instance$getBanPipes()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="getData">}\href{../../bdpar/html/Instance.html#method-getData}{\code{bdpar::Instance$getData()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="getDate">}\href{../../bdpar/html/Instance.html#method-getDate}{\code{bdpar::Instance$getDate()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="getFlowPipes">}\href{../../bdpar/html/Instance.html#method-getFlowPipes}{\code{bdpar::Instance$getFlowPipes()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="getNamesOfProperties">}\href{../../bdpar/html/Instance.html#method-getNamesOfProperties}{\code{bdpar::Instance$getNamesOfProperties()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="getPath">}\href{../../bdpar/html/Instance.html#method-getPath}{\code{bdpar::Instance$getPath()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="getProperties">}\href{../../bdpar/html/Instance.html#method-getProperties}{\code{bdpar::Instance$getProperties()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="getSource">}\href{../../bdpar/html/Instance.html#method-getSource}{\code{bdpar::Instance$getSource()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="getSpecificProperty">}\href{../../bdpar/html/Instance.html#method-getSpecificProperty}{\code{bdpar::Instance$getSpecificProperty()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="invalidate">}\href{../../bdpar/html/Instance.html#method-invalidate}{\code{bdpar::Instance$invalidate()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="isInstanceValid">}\href{../../bdpar/html/Instance.html#method-isInstanceValid}{\code{bdpar::Instance$isInstanceValid()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="isSpecificProperty">}\href{../../bdpar/html/Instance.html#method-isSpecificProperty}{\code{bdpar::Instance$isSpecificProperty()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="setData">}\href{../../bdpar/html/Instance.html#method-setData}{\code{bdpar::Instance$setData()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="setDate">}\href{../../bdpar/html/Instance.html#method-setDate}{\code{bdpar::Instance$setDate()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="setProperties">}\href{../../bdpar/html/Instance.html#method-setProperties}{\code{bdpar::Instance$setProperties()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="setSource">}\href{../../bdpar/html/Instance.html#method-setSource}{\code{bdpar::Instance$setSource()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="setSpecificProperty">}\href{../../bdpar/html/Instance.html#method-setSpecificProperty}{\code{bdpar::Instance$setSpecificProperty()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates a \code{\link{ExtractorYtbid}} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtractorYtbid$new(path, cachePath = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{A \code{\link{character}} value. Path of the ytbid file.}

\item{\code{cachePath}}{A \code{\link{character}} value. Path of the cache
location. If it is NULL, checks if is defined in the
\strong{"cache.youtube.path"} field of \code{\link{bdpar.Options}}
variable.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-obtainId"></a>}}
\if{latex}{\out{\hypertarget{method-obtainId}{}}}
\subsection{Method \code{obtainId()}}{
Obtains the ID of the specific Youtube's comment. Reads the ID
of the file indicated in the variable path.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtractorYtbid$obtainId()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getId"></a>}}
\if{latex}{\out{\hypertarget{method-getId}{}}}
\subsection{Method \code{getId()}}{
Gets the ID of an specific Youtube's comment.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtractorYtbid$getId()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Value of Youtube's comment ID.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-obtainDate"></a>}}
\if{latex}{\out{\hypertarget{method-obtainDate}{}}}
\subsection{Method \code{obtainDate()}}{
Obtains the date from a specific comment ID. If the comment
has been previously cached the comment date is loaded from cache path.
Otherwise, the request is perfomed using YouTube API and the date is then
formatted to the established standard.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtractorYtbid$obtainDate()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-obtainSource"></a>}}
\if{latex}{\out{\hypertarget{method-obtainSource}{}}}
\subsection{Method \code{obtainSource()}}{
Obtains the source from a specific comment ID. If the
comment has previously been cached the source is loaded from cache path.
Otherwise, the request is performed using on YouTube API.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtractorYtbid$obtainSource()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-toString"></a>}}
\if{latex}{\out{\hypertarget{method-toString}{}}}
\subsection{Method \code{toString()}}{
Returns a \code{\link{character}} representing the instance
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtractorYtbid$toString()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{\link{Instance}} \code{\link{character}} representation
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtractorYtbid$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
