% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ResourceHandler.R
\name{ResourceHandler}
\alias{ResourceHandler}
\title{Class that handles different types of resources}
\description{
Class that handles different types of resources.
}
\section{Details}{

It is a class that allows store the resources that are needed in the
\code{\link{GenericPipe}s} to avoid having to repeatedly read from
the file. File resources of type json are read and stored in memory.
}

\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{ResourceHandler$new()}}
\item \href{#method-isLoadResource}{\code{ResourceHandler$isLoadResource()}}
\item \href{#method-getResources}{\code{ResourceHandler$getResources()}}
\item \href{#method-setResources}{\code{ResourceHandler$setResources()}}
\item \href{#method-getNamesResources}{\code{ResourceHandler$getNamesResources()}}
\item \href{#method-clone}{\code{ResourceHandler$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates a \code{\link{ResourceHandler}} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResourceHandler$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-isLoadResource"></a>}}
\if{latex}{\out{\hypertarget{method-isLoadResource}{}}}
\subsection{Method \code{isLoadResource()}}{
From the resource path, it is checked if they have already
been loaded. In this case, the list of the requested resource is returned.
Otherwise, the resource variable is added to the list of resources, and
the resource list is returned. In the event that the resource file does
not exist, NULL is returned.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResourceHandler$isLoadResource(pathResource)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{pathResource}}{A (\emph{character}) value. The resource file path.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The resources list is returned, if they exist.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getResources"></a>}}
\if{latex}{\out{\hypertarget{method-getResources}{}}}
\subsection{Method \code{getResources()}}{
Gets of resources variable.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResourceHandler$getResources()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The value of resources variable.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setResources"></a>}}
\if{latex}{\out{\hypertarget{method-setResources}{}}}
\subsection{Method \code{setResources()}}{
Sets of resources variable.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResourceHandler$setResources(resources)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{resources}}{The new value of resources.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getNamesResources"></a>}}
\if{latex}{\out{\hypertarget{method-getNamesResources}{}}}
\subsection{Method \code{getNamesResources()}}{
Gets of names of resources
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResourceHandler$getNamesResources()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Value of names of resources.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResourceHandler$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
