% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-middleware.R
\name{cors}
\alias{cors}
\title{Allow Cross-Origin-Requests}
\usage{
cors(
  beakr,
  path = NULL,
  methods = c("GET", "POST", "PUT", "DELETE", "OPTIONS", "PATCH"),
  origin = "*",
  credentials = NULL,
  headers = NULL,
  maxAge = NULL,
  expose = NULL
)
}
\arguments{
\item{beakr}{\code{Beakr} instance object.}

\item{path}{String representing a path for which to specify a CORS policy.
Default \code{NULL} applies a single policy for all URL routes.}

\item{methods}{A vector of the request methods to allow. i.e
\code{Access-Control-Allow-Methods} parameter, e.g \code{GET, POST}.}

\item{origin}{A vector of the request origin(s) for which resource sharing
is enabled. i.e \code{Access-Control-Allow-Origin} response header parameter.}

\item{credentials}{A boolean to enable/disable credentialed requests. i.e
\code{Access-Control-Allow-Credentials} response header parameter.}

\item{headers}{A vector of the allowed headers. i.e
\code{Access-Control-Allow-Headers} response header parameter.}

\item{maxAge}{The max age, in seconds. i.e \code{Access-Control-Max-Age}
response header parameter.}

\item{expose}{The headers to expose. i.e \code{Access-Control-Expose-Headers}
response header parameter.}
}
\value{
A \code{Beakr} instance with CORS enabled
}
\description{
Allow Cross-Origin Resource Sharing headers as described in
\href{https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS}{MDN Web Docs}.
Cross-origin resource sharing is a mechanism that allows restricted resources
on a web page to be requested from another domain(origin) outside the domain
from which the first resource was served.
}
\note{
You can verify that CORS is enabled by using the Chrome browser and
opening up the Developer Tools. The "Network" tab allows you to inspect
response headers and see where the \code{Cross-Origin} policy is specified.

If you run the example in the console, be sure to
\code{stopServer(bekar)} when you are done.
}
\examples{
\donttest{
library(beakr)

# Create an new beakr instance
beakr <- newBeakr()

# beakr pipeline
beakr \%>\%

  # Enable CORS
  cors() \%>\%

  # Respond to GET requests at the "/hi" route
  httpGET(path = "/hi", function(req, res, err) {
    print("Hello, World!")
  }) \%>\%

  # Respond to GET requests at the "/bye" route
  httpGET(path = "/bye", function(req, res, err) {
    print("Farewell, my friends.")
  }) \%>\%

  # Start the server on port 25118
  listen(host = "127.0.0.1", port = 25118, daemon = TRUE)

# ------------------------------------------------------------
# POINT YOUR BROWSER AT:
# * http://127.0.0.1:25118/hi
# * http://127.0.0.1:25118/bye
#
# THEN, STOP THE SERVER WITH stopServer(beakr)
# ------------------------------------------------------------

# Stop the beakr instance server
stopServer(beakr)
}
}
\seealso{
\link{Request}, \link{Response}, \link{Error}
}
