% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beanz_present.R
\name{r.pred.subgrp.effect}
\alias{r.pred.subgrp.effect}
\title{Predictive Distribution}
\usage{
r.pred.subgrp.effect(stan.rst, dat.sub, var.estvar, vrange)
}
\arguments{
\item{stan.rst}{a class \code{beanz.stan} object generated by
\code{\link{call.stan}}}

\item{dat.sub}{dataset with subgroup treatment effect summary data}

\item{var.estvar}{column names in dat.sub that corresponds to treatment effect
estimation and the estimated variance}

\item{vrange}{the pair of \eqn{\Delta_1} and \eqn{\Delta_2}. see \code{\link{beanz-package}}.}
}
\value{
A dataframe of predicted subgroup treament effects. That is, the
    distribution of \deqn{ \theta_g | \widehat{\theta}_1, \widehat{\sigma}^2_1, \ldots,
    \widehat{\theta}_G, \widehat{\sigma}^2_G.}
}
\description{
Get the predictive distribution of the subgroup treatment effects
}
\examples{
\dontrun{
var.cov    <- c("sodium", "lvef", "any.vasodilator.use");
var.resp   <- "y";
var.trt    <- "trt";
var.censor <- "censor";
resptype   <- "survival";
var.estvar <- c("Estimate", "Variance");

subgrp.effect <- r.get.subgrp.raw(solvd.sub,
                                  var.resp   = var.resp,
                                  var.trt    = var.trt,
                                  var.cov    = var.cov,
                                  var.censor = var.censor,
                                  resptype   = resptype);

rst.nse    <- call.stan("nse", dat.sub=subgrp.effect,
                         var.estvar = var.estvar, var.cov = var.cov,
                         lst.par.pri = list(vtau=1000, vrange=c(0,0)),
                         chains=1, iter=4000,
                         warmup=2000, thin=2, seed=1000);
pred.effect <- r.pred.subgrp.effect(rst.nes,
                                    dat.sub = solvd.sub,
                                    var.estvar = var.estvar,
                                    vrange = c(0,0));}
}

