% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_beast2_internal_filenames.R
\name{create_beast2_internal_filenames}
\alias{create_beast2_internal_filenames}
\title{Create a list with the internally used BEAST2 filenames}
\usage{
create_beast2_internal_filenames(beast2_options)
}
\arguments{
\item{beast2_options}{a set of BEAST2 options,
that are the R equivalent of the BEAST2 command-line options,
as can be created by \link{create_beast2_options}}
}
\value{
a list with the internally used BEAST2 filenames
}
\description{
Create a list with the internally used BEAST2 filenames
}
\examples{
beast2_options <- create_beast2_options(
  input_filename = get_beastier_path("2_4.xml")
)
if (is_beast2_installed()) {
  create_beast2_internal_filenames(beast2_options)
}
}
