% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_param.R
\name{create_clock_rate_param}
\alias{create_clock_rate_param}
\alias{create_param_clock_rate}
\title{Create a parameter called \code{clock_rate},
  as needed by \code{\link{create_strict_clock_model}}}
\usage{
create_clock_rate_param(value = "1.0", estimate = FALSE, id = NA)
}
\arguments{
\item{value}{value of the parameter}

\item{estimate}{TRUE if this parameter is estimated by BEAST2,
FALSE otherwise}

\item{id}{the alignment id}
}
\value{
a parameter called rate
}
\description{
Create a parameter called \code{clock_rate},
  as needed by \code{\link{create_strict_clock_model}}
}
\examples{
  clock_rate_param <- create_clock_rate_param(
    id = "anthus_aco", estimate = FALSE, value = 1.0
  )

  # Use the parameter in a clock model
  strict_clock_model <- create_strict_clock_model(
    clock_rate_param = clock_rate_param
  )

  # Use the distribution to create a BEAST2 input file
  create_beast2_input_file(
    input_filenames = get_fasta_filename(),
    "create_clock_rate_param.xml",
    clock_models = strict_clock_model
  )
  testit::assert(file.exists("create_clock_rate_param.xml"))
}
\seealso{
the function \code{\link{create_param}} contains a list
  of all parameters that can be created
}
\author{
Richel J.C. Bilderbeek
}
