% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_phylogeny.R
\name{check_phylogeny}
\alias{check_phylogeny}
\title{Check if the phylogeny is a valid phylogeny object.}
\usage{
check_phylogeny(phylogeny)
}
\arguments{
\item{phylogeny}{a phylogeny of type \code{\link[ape]{phylo}}}
}
\value{
nothing
}
\description{
Calls \code{stop} if the phylogeny is invalid
}
\examples{
 phylogeny <- ape::read.tree(text = "(A:1, B:1):1;")
 testthat::expect_silent(check_phylogeny(phylogeny))

 # Must stop on non-phylogenies
 testthat::expect_error(check_phylogeny(phylo = "nonsense"))
 testthat::expect_error(check_phylogeny(phylo = NULL))
 testthat::expect_error(check_phylogeny(phylo = NA))
}
\seealso{
Use \link[ape]{read.tree} to create a phylogeny
}
\author{
Richèl J.C. Bilderbeek
}
