% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_param.R
\name{is_s_param}
\alias{is_s_param}
\title{Determine if the object is a valid
s parameter}
\usage{
is_s_param(x)
}
\arguments{
\item{x}{an object, to be determined if it is a valid
s parameter}
}
\value{
TRUE if x is a valid s parameter,
  FALSE otherwise
}
\description{
Determine if the object is a valid
s parameter
}
\examples{
library(testthat)

expect_false(is_s_param(create_alpha_param()))
expect_false(is_s_param(create_beta_param()))
expect_false(is_s_param(create_clock_rate_param()))
expect_false(is_s_param(create_kappa_1_param()))
expect_false(is_s_param(create_kappa_2_param()))
expect_false(is_s_param(create_lambda_param()))
expect_false(is_s_param(create_m_param()))
expect_false(is_s_param(create_mean_param()))
expect_false(is_s_param(create_mu_param()))
expect_false(is_s_param(create_rate_ac_param()))
expect_false(is_s_param(create_rate_ag_param()))
expect_false(is_s_param(create_rate_at_param()))
expect_false(is_s_param(create_rate_cg_param()))
expect_false(is_s_param(create_rate_ct_param()))
expect_false(is_s_param(create_rate_gt_param()))
expect_true(is_s_param(create_s_param()))
expect_false(is_s_param(create_scale_param()))
expect_false(is_s_param(create_sigma_param()))

expect_false(is_s_param(NA))
expect_false(is_s_param(NULL))
expect_false(is_s_param("nonsense"))
expect_false(is_s_param(create_jc69_site_model()))
expect_false(is_s_param(create_strict_clock_model()))
expect_false(is_s_param(create_yule_tree_prior()))
expect_false(is_s_param(create_mcmc()))
}
\author{
Richèl J.C. Bilderbeek
}
