% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_one_int.R
\name{is_one_int}
\alias{is_one_int}
\title{Determines if the argument is a whole number}
\usage{
is_one_int(x, tolerance = .Machine$double.eps^0.5)
}
\arguments{
\item{x}{the object to be determined of if it is one integer}

\item{tolerance}{tolerance to rounding errors}
}
\description{
Determines if the argument is a whole number
}
\examples{
library(testthat)

expect_true(is_one_int(314))
expect_true(is_one_int(0))
expect_true(is_one_int(-314))
expect_false(is_one_int(3.14))
expect_false(is_one_int(NULL))
expect_false(is_one_int(NA))
expect_false(is_one_int(Inf))
expect_false(is_one_int("nonsense"))
expect_false(is_one_int(c()))
expect_false(is_one_int(c(1, 2)))
}
\author{
Richèl J.C. Bilderbeek
}
