% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_gamma_site_model_n_distrs.R
\name{get_gamma_site_model_n_distrs}
\alias{get_gamma_site_model_n_distrs}
\title{Get the number of distributions in a gamma site model}
\usage{
get_gamma_site_model_n_distrs(gamma_site_model)
}
\arguments{
\item{gamma_site_model}{a site model's gamma site model,
as returned by \code{\link{create_gamma_site_model}}}
}
\value{
the number of distributions a gamma site model has
}
\description{
Get the number of distributions in a gamma site model
}
\examples{
  gamma_site_model <- create_gamma_site_model()
  n_distrs <- get_gamma_site_model_n_distrs(
    gamma_site_model
   )
  testit::assert(n_distrs == 0)

  gamma_site_model <- create_gamma_site_model(
    gamma_cat_count = 2,
    gamma_shape_prior_distr = create_exp_distr()
  )
  n_distrs <- get_gamma_site_model_n_distrs(gamma_site_model)
  testit::assert(n_distrs == 1)
}
\seealso{
Use \link{create_gamma_site_model} to create a gamma site model
}
\author{
Richèl J.C. Bilderbeek
}
