% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_distr.R
\name{is_inv_gamma_distr}
\alias{is_inv_gamma_distr}
\title{Determine if the object is a valid
inverse-gamma distribution
as created by \code{\link{create_inv_gamma_distr}}}
\usage{
is_inv_gamma_distr(x)
}
\arguments{
\item{x}{an object, to be determined if it is a valid
inverse-gamma distribution}
}
\value{
TRUE if x is a valid inverse-gamma distribution,
  FALSE otherwise
}
\description{
Determine if the object is a valid
inverse-gamma distribution
as created by \code{\link{create_inv_gamma_distr}}
}
\examples{
library(testthat)

expect_true(is_inv_gamma_distr(create_inv_gamma_distr()))

expect_false(is_inv_gamma_distr(create_laplace_distr()))
expect_false(is_inv_gamma_distr(NA))
expect_false(is_inv_gamma_distr(NULL))
expect_false(is_inv_gamma_distr("nonsense"))
}
\seealso{
use \code{\link{is_distr}} to see if x is any
  distribution
}
\author{
Richèl J.C. Bilderbeek
}
