% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_beauti_options.R
\name{check_beauti_options}
\alias{check_beauti_options}
\title{Check if the \code{beauti_options} is a valid \code{beauti_options} object.}
\usage{
check_beauti_options(beauti_options)
}
\arguments{
\item{beauti_options}{one BEAUti options object,
as returned by \code{\link{create_beauti_options}}}
}
\value{
nothing
}
\description{
Calls \code{stop} if the \code{beauti_options} object is invalid
}
\examples{
 testthat::expect_silent(check_beauti_options(create_beauti_options()))

 # Must stop on nonsense
 testthat::expect_error(check_beauti_options(beauti_options = "nonsense"))
 testthat::expect_error(check_beauti_options(beauti_options = NULL))
 testthat::expect_error(check_beauti_options(beauti_options = NA))
}
\seealso{
Use \link{create_beauti_options} to create a valid
  BEAUti options setup
}
\author{
Richèl J.C. Bilderbeek
}
