% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_gamma_site_model.R
\name{create_gamma_site_model}
\alias{create_gamma_site_model}
\title{Create a gamma site model, part of a site model}
\usage{
create_gamma_site_model(
  gamma_cat_count = "0",
  gamma_shape = "1.0",
  prop_invariant = "0.0",
  gamma_shape_prior_distr = NA,
  freq_equilibrium = "estimated"
)
}
\arguments{
\item{gamma_cat_count}{the number of gamma categories, must
be an integer with value zero or more}

\item{gamma_shape}{gamma curve shape parameter}

\item{prop_invariant}{the proportion invariant, must be a value
from 0.0 to 1.0}

\item{gamma_shape_prior_distr}{the distribution of the gamma shape prior.
\code{gamma_shape_prior_distr} must be \code{NA} for
a \code{gamma_cat_count} of zero or one.
For a \code{gamma_cat_count} of two or more,
leaving \code{gamma_shape_prior_distr} equal to its default
value of \code{NA}, a default distribution is used.
Else \code{gamma_shape_prior_distr} must be a
distribution, as can be created by \code{\link{create_distr}}}

\item{freq_equilibrium}{the frequency in which the rates are at equilibrium
are either \code{estimated}, \code{empirical} or \code{all_equal}.
\code{get_freq_equilibrium_names} returns the possible values
for \code{freq_equilibrium}}
}
\value{
a gamma site model
}
\description{
Create a gamma site model, part of a site model
}
\examples{
  gamma_site_model <- create_gamma_site_model(prop_invariant = 0.5)

  site_model <- create_hky_site_model(gamma_site_model = gamma_site_model)

  beast2_input_file <- tempfile(fileext = ".xml")
  create_beast2_input_file(
    get_fasta_filename(),
    beast2_input_file,
    site_model = site_model
  )
  testit::assert(file.exists(beast2_input_file))
}
\seealso{
Use \code{\link{create_gamma_site_model}}
  to create a gamma site model
}
\author{
Richèl J.C. Bilderbeek
}
