% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_tree_prior.R
\name{create_cep_tree_prior}
\alias{create_cep_tree_prior}
\alias{create_tree_prior_cep}
\title{Create a Coalescent Exponential Population tree prior}
\usage{
create_cep_tree_prior(
  id = NA,
  pop_size_distr = create_one_div_x_distr(),
  growth_rate_distr = create_laplace_distr()
)
}
\arguments{
\item{id}{the ID of the alignment}

\item{pop_size_distr}{the population distribution,
as created by a \code{\link{create_distr}} function}

\item{growth_rate_distr}{the growth rate distribution,
as created by a \code{\link{create_distr}} function}
}
\value{
a Coalescent Exponential Population tree_prior
}
\description{
Create a Coalescent Exponential Population tree prior
}
\examples{
check_empty_beautier_folder()

cep_tree_prior <- create_cep_tree_prior()

beast2_input_file <- get_beautier_tempfilename()
create_beast2_input_file(
  input_filename = get_fasta_filename(),
  beast2_input_file,
  tree_prior = cep_tree_prior
)
file.remove(beast2_input_file)

remove_beautier_folder()
check_empty_beautier_folder()
}
\seealso{
An alignment ID can be extracted from
  its FASTA filename using \code{\link{get_alignment_id}}
}
\author{
Richèl J.C. Bilderbeek
}
