% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_site_model.R
\name{create_tn93_site_model}
\alias{create_tn93_site_model}
\alias{create_site_model_tn93}
\title{Create a TN93 site model}
\usage{
create_tn93_site_model(
  id = NA,
  gamma_site_model = create_gamma_site_model(),
  kappa_1_param = create_kappa_1_param(),
  kappa_2_param = create_kappa_2_param(),
  kappa_1_prior_distr = create_log_normal_distr(m = 1, s = 1.25),
  kappa_2_prior_distr = create_log_normal_distr(m = 1, s = 1.25),
  freq_equilibrium = "estimated"
)
}
\arguments{
\item{id}{the IDs of the alignment (can be extracted from
the FASTA filename using \code{\link{get_alignment_id}})}

\item{gamma_site_model}{a gamma site model, as created
by \code{\link{create_gamma_site_model}}}

\item{kappa_1_param}{the 'kappa 1' parameter,
a numeric value.
For advanced usage, use the structure
as returned by \code{\link{create_kappa_1_param}}}

\item{kappa_2_param}{the 'kappa 2' parameter,
a numeric value.
For advanced usage, use the structure
as returned by \code{\link{create_kappa_2_param}}}

\item{kappa_1_prior_distr}{the distribution of the kappa 1 prior,
which is a log-normal distribution
(as created by \code{\link{create_log_normal_distr}})
by default}

\item{kappa_2_prior_distr}{the distribution of the kappa 2 prior,
which is a log-normal distribution
(as created by \code{\link{create_log_normal_distr}})
by default}

\item{freq_equilibrium}{the frequency in which the rates are at equilibrium
are either \code{estimated}, \code{empirical} or \code{all_equal}.
\code{get_freq_equilibrium_names} returns the possible values
for \code{freq_equilibrium}}
}
\value{
a TN93 site_model
}
\description{
Create a TN93 site model
}
\examples{
if (is_on_ci()) {

  tn93_site_model <- create_tn93_site_model(
    kappa_1_param = 2.0,
    kappa_2_param = 2.0
  )

  output_filename <- get_beautier_tempfilename()
  create_beast2_input_file(
    input_filename = get_fasta_filename(),
    output_filename = output_filename,
    site_model = tn93_site_model
  )
  file.remove(output_filename)

  remove_beautier_folder()
}
}
\author{
Richèl J.C. Bilderbeek
}
