% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_param.R
\name{create_clock_rate_param}
\alias{create_clock_rate_param}
\alias{create_param_clock_rate}
\title{Create a parameter called \code{clock_rate},
  as needed by \code{\link{create_strict_clock_model}}}
\usage{
create_clock_rate_param(value = "1.0", id = NA)
}
\arguments{
\item{value}{value of the parameter}

\item{id}{the parameter's ID}
}
\value{
a parameter called rate
}
\description{
Create a parameter called \code{clock_rate},
  as needed by \code{\link{create_strict_clock_model}}
}
\note{
It cannot be estimated (as a hyper parameter) yet.
}
\examples{
clock_rate_param <- create_clock_rate_param(
  id = "anthus_aco", value = 1.0
)

# Use the parameter in a clock model
strict_clock_model <- create_strict_clock_model(
  clock_rate_param = clock_rate_param
)

# Use the distribution to create a BEAST2 input file
beast2_input_file <- get_beautier_tempfilename()
create_beast2_input_file(
  input_filename = get_fasta_filename(),
  beast2_input_file,
  clock_model = strict_clock_model
)
file.remove(beast2_input_file)
}
\seealso{
the function \code{\link{create_param}} contains a list
  of all parameters that can be created
}
\author{
Richèl J.C. Bilderbeek
}
