% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/complecs.R
\name{complecs}
\alias{complecs}
\alias{print.complecs}
\title{Create a COMPLECS graph}
\usage{
complecs(
  input,
  title = "COMPLECS overview",
  layout = "neato",
  graph_styling = list(c("outputorder", "nodesfirst", "graph"), c("overlap", "false",
    "graph"), c("fixedsize", "false", "node")),
  directed = TRUE,
  outputFile = NULL,
  outputWidth = NULL,
  outputHeight = NULL,
  returnSvgOnly = FALSE,
  maxLabelLength = 20,
  regExReplacements = list(c("\\\\\\"", "`"), c("\\\\'", "`"), c("\\\\\\\\", "/"))
)

\method{print}{complecs}(
  x,
  width = x$input$width,
  height = x$input$height,
  title = DiagrammeR::get_graph_name(x$output$graph),
  ...
)
}
\arguments{
\item{input}{Either a link to a Google Sheet, or a path to an Excel file.}

\item{title}{The title of the COMPLECS graph.}

\item{layout}{The layout to use; has to be one of the \code{DiagrammeR} layout
types (\code{dot}, \code{neato}, \code{circo} and \code{twopi}).}

\item{graph_styling}{Additional styling to apply; a list with three-element
vectors, where the three elements correspond to, respectively, the \code{attr},
\code{value}, and \code{attr_type} arguments for [DiagrammeR::add_global_graph_attrs().}

\item{directed}{Whether to draw directed arrows or not.}

\item{outputFile}{A character vector where each element is one path (including
filename) to write the graph to.}

\item{outputWidth, outputHeight}{If not \code{NULL}, a way to override the width and
height when calling \code{complecs} to generate a COMPLECS overview.}

\item{returnSvgOnly}{Whether to only return the SVG in a character vector.}

\item{maxLabelLength}{The number of characters where to wrap the labels.}

\item{regExReplacements}{A list of pairs of regular
expressions that will be applied to the specifications
before generating the ABCD. This can be used to sanitize
problematic characters (e.g. ', " and \).}

\item{x}{The object to print (i.e. a result of a call to \code{complecs}).}

\item{width, height}{If not \code{NULL}, a way to override the width and
height when calling \code{print} to print a COMPLECS overview.}

\item{...}{Any additional arguments for the \code{\link[=print]{print()}} method are passed
to \code{\link[DiagrammeR:render_graph]{DiagrammeR::render_graph()}}.}
}
\value{
A \code{complecs} object that includes the graph and the graph in SVG in
\code{output$graph} and \code{output$graphSvg}.
}
\description{
COMPLECS was developed to help make sense of complex systems. It reads data from a
number of worksheets in a spreadsheet and generates a diagram according to those
specifications. Originally, COMPLECS was developed to visualise a problem during
the needs assessment phase of intervention development.
}
\details{
COMPLECS is a recursive acronym for COMPLECS Organises Multiple Players & Linked
Environments using Connected Specifications.
}
\examples{
complecs(paste0("https://docs.google.com/spreadsheets/d/",
         "1WMO15xroy4a0RfpuZ8GhT-NfDoxwS34w9PrWp8rGjjk"));
}
