% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/benchmark_io.R
\name{benchmark_io}
\alias{benchmark_io}
\alias{bm_read}
\alias{bm_write}
\title{IO benchmarks}
\usage{
benchmark_io(runs = 3, size = c(5, 50), tmpdir = tempdir(),
  verbose = TRUE, cores = 0L)

bm_read(runs = 3, size = c(5, 50), tmpdir = tempdir(),
  verbose = TRUE)

bm_write(runs = 3, size = c(5, 50), tmpdir = tempdir(),
  verbose = TRUE)
}
\arguments{
\item{runs}{Number of times to run the test. Default 3.}

\item{size}{a number specifying the approximate size of the generated csv. 
Must be one of 5 or 50}

\item{tmpdir}{a non-empty character vector giving the directory name. Default \code{tempdir()}}

\item{verbose}{Default TRUE.}

\item{cores}{Default 0 (serial). When cores > 0, the benchmark is run in parallel.}
}
\description{
Benchmarking reading and writing a csv file (containing random numbers).
The tests are essentially \code{write.csv(x)} and \code{read.csv(...)} where \code{x} 
is a data frame.
Of \code{size}MB.
}
