% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indicators.R
\name{shannon}
\alias{shannon}
\alias{shannon_}
\title{Shannon's Index or Entropy}
\usage{
shannon(.data = NULL, taxon, count, base = 2)

shannon_(.data = NULL, taxon, count, base = 2)
}
\arguments{
\item{.data}{data in a \code{data.frame}, \code{data_frame}, 
\code{data.table}, database etc.}

\item{taxon}{taxa names (\code{character})}

\item{count}{counts (\code{numeric})}

\item{base}{the base with respect to which logarithms are computed. 
Defaults to 2.}
}
\value{
Shannon's entropy
}
\description{
Compute entropy according to Shannon (1948)
}
\section{Functions}{
\itemize{
\item \code{shannon_}: version suitable for calling from a function
(see package \pkg{lazyeval}).
}}

\examples{
 shannon(
     taxon = c("Euspira pulchella", "Nephtys cirrosa"), 
     count = c(4, 6)
 )

}
\references{
Shannon, C. E., 1948. A Mathematical Theory of Communication.
     Bell System Technical Journal 27: 379-423.
}
