% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{read_ambi}
\alias{read_ambi}
\alias{validate_ambi}
\title{Read and Validate AMBI Sensitivity Data}
\usage{
read_ambi(filename)

validate_ambi(.data)
}
\arguments{
\item{filename}{name of the AMBI sensitivity file (character)}

\item{.data}{table in AMBI-format}
}
\description{
This function reads and checks files with AMBI sensitivity data. 
The data should be stored in 'comma separated values' format (csv) 
consisting of two columns:
\itemize{
		\item{TAXON} {species name;}
 	\item{GROUP} {Roman numeral (I, II, III, IV, V) giving the sensitivity
     group}
}
}
\details{
The function performs the following tasks:
\itemize{
		\item{checks the existence of \code{filename};}
 	\item{checks availablitity of required columns (case insensitive);}
 	\item{removes redundant spaces;}
 	\item{removes duplicated records.}
 }
}
\section{Functions}{
\itemize{
\item \code{validate_ambi()}: validator for AMBI-format

}}
\references{
Borja, A., J. Franco and V. Perez, 2000. A Marine Biotic Index 
 to Establish the Ecological Quality of Soft-Bottom Benthos Within 
 European Estuarine and Coastal Environments. 
 Marine Pollution Bulletin 40:1100-1114
}
