% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betaSandwich-methods-beta-sandwich.R
\name{summary.betasandwich}
\alias{summary.betasandwich}
\title{Summary Method for an Object of Class \code{betasandwich}}
\usage{
\method{summary}{betasandwich}(object, alpha = NULL, digits = 4, ...)
}
\arguments{
\item{object}{Object of class \code{betasandwich}.}

\item{alpha}{Numeric vector.
Significance level \eqn{\alpha}.
If \code{alpha = NULL},
use the argument \code{alpha} used in \code{object}.}

\item{digits}{Digits to print.}

\item{...}{additional arguments.}
}
\value{
Returns a matrix of
standardized regression slopes,
standard errors,
test statistics,
degrees of freedom,
p-values,
and
confidence intervals.
}
\description{
Summary Method for an Object of Class \code{betasandwich}
}
\examples{
object <- lm(QUALITY ~ NARTIC + PCTGRT + PCTSUPP, data = nas1982)
std <- BetaHC(object)
summary(std)

}
\author{
Ivan Jacob Agaloos Pesigan
}
\keyword{methods}
