% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotdata.R
\name{PlotData}
\alias{PlotData}
\title{Plot Data}
\usage{
PlotData(data.MCMC = NULL, data.type = "Mean", job.title = NULL,
  run.repeated = FALSE, run.split = FALSE, y.split = FALSE,
  ribbon.plot = TRUE, monochrome = TRUE, plot.colors = c("#495054",
  "#e3e8ea"), y.text = "Score", x.text = NULL, project.dir = "Results/",
  save.data = FALSE, graphic.type = "pptx", plot.size = "15,10",
  scaling = 100, plot.aspect = NULL, vector.graphic = TRUE,
  point.size = 15, font.type = "serif", one.file = TRUE, ppi = 300,
  units = "in", layout = "pw", layout.inverse = FALSE, ...)
}
\arguments{
\item{data.MCMC}{data to plot data from, Default: NULL}

\item{data.type}{define what kind of data is being used, Default: 'Mean'}

\item{job.title}{title of analysis, Default: NULL}

\item{run.repeated}{logical, indicating whether or not to use repeated measures plot, Default: FALSE}

\item{run.split}{logical, indicating whether or not to use split violin plot and compare distribution between groups, Default: FALSE}

\item{y.split}{logical, indicating whether or not to split within (TRUE) or between groups, Default: FALSE}

\item{ribbon.plot}{logical, indicating whether or not to use ribbon plot for HDI, Default: TRUE}

\item{monochrome}{logical, indicating whether or not to use monochrome colors, else use \link[bfw]{DistinctColors}, Default: TRUE}

\item{plot.colors}{range of color to use, Default: c("#495054", "#e3e8ea")}

\item{y.text}{label on y axis, Default: 'Score'}

\item{x.text}{label on x axis, Default: NULL}

\item{project.dir}{define where to save data, Default: 'Results/'}

\item{save.data}{logical, indicating whether or not to save data, Default: FALSE}

\item{graphic.type}{type of graphics to use (e.g., pdf, png, ps), Default: 'pptx'}

\item{plot.size}{size of plot, Default: '15,10'}

\item{scaling}{scale size of plot, Default: 100}

\item{plot.aspect}{aspect of plot, Default: NULL}

\item{vector.graphic}{logical, indicating whether or not visualizations should be vector or raster graphics, Default: TRUE}

\item{point.size}{point size used for visualizations, Default: 15}

\item{font.type}{font type used for visualizations, Default: 'serif'}

\item{one.file}{logical, indicating whether or not visualizations should be placed in one or several files, Default: TRUE}

\item{ppi}{define pixel per inch used for visualizations, Default: 300}

\item{units}{define unit of length used for visualizations, Default: 'in'}

\item{layout}{define a layout size for visualizations, Default: 'pw'}

\item{layout.inverse}{logical, indicating whether or not to inverse layout (e.g., landscape) , Default: FALSE}

\item{...}{further arguments passed to or from other methods}
}
\description{
Plot data as violin plot visualizing density, box plots to display HDI, whiskers to display standard deviation
}
\seealso{
\code{\link[ggplot2]{ggproto}},
\code{\link[ggplot2]{aes}},
\code{\link[ggplot2]{element_blank}},
\code{\link[ggplot2]{element_line}},
\code{\link[ggplot2]{element_rect}},
\code{\link[ggplot2]{element_text}},
\code{\link[ggplot2]{geom_boxplot}},
\code{\link[ggplot2]{geom_errorbar}},
\code{\link[ggplot2]{geom_line}},
\code{\link[ggplot2]{geom_ribbon}},
\code{\link[ggplot2]{geom_violin}},
\code{\link[ggplot2]{ggplot}},
\code{\link[ggplot2]{scale_fill_manual}},
\code{\link[ggplot2]{scale_x_discrete}},
\code{\link[ggplot2]{theme}},
\code{\link[ggplot2]{layer}},
\code{\link[ggplot2]{labs}}
\code{\link[plyr]{arrange}}
\code{\link[plyr]{rbind.fill}}
\code{\link[scales]{zero_range}}
\code{\link[grid]{grobTree}},
\code{\link[grid]{grobName}},
\code{\link[grid]{unit}}
\code{\link[stats]{approxfun}}
\code{\link[utils]{tail}}
\code{\link[grDevices]{colorRampPalette}},
\code{\link[grDevices]{dev.new}},
\code{\link[grDevices]{recordPlot}},
\code{\link[grDevices]{graphics.off}},
\code{\link[grDevices]{dev.list}},
\code{\link[grDevices]{dev.off}}
}
