% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_functions.R
\name{sp_bgsmtr}
\alias{sp_bgsmtr}
\title{Spatial Bayesian Group Sparse Multi-Task Regression for Imaging Genetics}
\usage{
sp_bgsmtr(X, Y, method = "MCMC", rho = NULL, lambdasq = NULL,
  alpha = NULL, A = NULL, c.star = NULL, FDR_opt = TRUE,
  WAIC_opt = TRUE, iter_num = 10000, burn_in = 5001)
}
\arguments{
\item{X}{A d-by-n matrix; d is the number of SNPs and n is the number of subjects. Each row of X should correspond to a particular SNP
and each column should correspond to a particular subject. Each element of X should give the number of minor alleles for the corresponding
SNP and subject. The function will center each row of X to have mean zero prior to running the Gibbs sampling algorithm.}

\item{Y}{A c-by-n matrix; c is the number of phenotypes (brain imaging measures) and n is the number of subjects. Each row of
Y should correspond to a particular phenotype and each column should correspond to a particular subject. Each element of Y should give
the measured value for the corresponding phentoype and subject. The function will center and scale each row of Y to have mean zero and unit
variance prior to running the Gibbs sampling algorithm.}

\item{method}{A string, either 'MCMC' or 'MFVB'. If 'MCMC', the Gibbs sampling method will be used. If 'MFVB', mean field variational bayes method will be used.}

\item{rho}{spatial cohesion paramter. If no value has been assigned to it, it takes 0.8 by default.}

\item{lambdasq}{A tuning paratmeter. If no value has beeen assigned to it, it takes 1000 by default.}

\item{alpha}{Bayesian False Discovery Rate (FDR) level. Default level is 0.05.}

\item{A}{A c/2 by c/2 neighborhood structure matrix for different brain regions.}

\item{c.star}{The threshold for computing posterior tail probabilities p_{ij} for Bayesian FDR as defined in Section 3.2 of Song et al. (2018). If not specified the default is to set this threshold as the minimum posterior standard deviation, where the minimum is taken over all regression coefficients in the model.}

\item{FDR_opt}{A logical operator for computing Bayesian FDR. By default, it's TRUE.}

\item{WAIC_opt}{A logical operator for computing WAIC from MCMC method. By default, it's TRUE.}

\item{iter_num}{Positive integer representing the total number of iterations to run the Gibbs sampler. Defaults to 10,000.}

\item{burn_in}{Nonnegative integer representing the number of MCMC samples to discard as burn-in. Defaults to 5001.}
}
\value{
A list with the elements
\item{WAIC}{WAIC is computed from the MCMC output if "MCMC" is chosen for method.}
\item{lower_boud}{Lower bound from MFVB output if "MFVB is choosen for method.}
\item{Gibbs_setup}{A list providing values for the input parameters of the function.}
\item{Gibbs_W_summaries}{A list with five components, each component being a d-by-c matrix giving some posterior summary of the regression parameter
matrix W, where the ij-th element of W represents the association between the i-th SNP and j-th phenotype.

-Gibbs_W_summaries$W_post_mean is a d-by-c matrix giving the posterior mean of W.



-Gibbs_W_summaries$W_post_mode is a d-by-c matrix giving the posterior mode of W.



-Gibbs_W_summaries$W_post_sd is a d-by-c matrix giving the posterior standard deviation for each element of W.



-Gibbs_W_summaries$W_2.5_quantile is a d-by-c matrix giving the posterior 2.5 percent quantile for each element of W.



-Gibbs_W_summaries$W_97.5_quantile is a d-by-c matrix giving the posterior 97.5 percent quantile for each element of W.'}

\item{FDR_summaries}{A list with three components providing the summaries for estimated Bayesian FDR results for both MCMC and MFVB methods. Details for Bayesian FDR computation could be found at Morris et al.(2008).

-sensitivity_rate is the estimated sensitivity rate for each region.

-specificity_rate is the estimated specificity rate for each region.

-significant_snp_idx is the index of estimated significant/important SNPs for each region.
}

\item{MFVB_summaries}{A list with four components, each component is the mean field variational bayes approximation summary of model paramters.

-Number of Iteration is how many iterations it takes for convergence.

-W_post_mean is MFVB approximation of W.

-Sigma_post_mean is MFVB approximation of Sigma.

-omega_post_mean is MFVB approximation of Omega.

}
}
\description{
Bayesian Group Sparse Multi-Task Regression that allows for two types of correlation typically seen in structural brain imaging data. First, the spatial correlation in the imaging phenotypes obtained from neighbouring regions of the brain. Second, the correlation between corresponding measures on opposite hemispheres.
}
\examples{
data(sp_bgsmtr_example_data)
names(sp_bgsmtr_example_data)


\dontrun{

# Run the example data with Gibbs sampling and compute Bayesian FDR as follow:

fit_mcmc = sp_bgsmtr(X = sp_bgsmtr_example_data$SNP_data,
Y = sp_bgsmtr_example_data$BrainMeasures, method = "MCMC",
A = bgsmtr_example_data$neighborhood_structure, rho = 0.8,
FDR_opt = TRUE, WAIC_opt = TRUE,lambdasq = 1000, iter_num = 10000.)

# MCMC estimation results for regression parameter W and estimated Bayesian FDR summaries

fit_mcmc$Gibbs_W_summaries
fit_mcmc$FDR_summaries

# The WAIC could be also obtained as:

fit_mcmc$WAIC

# Run the example data with mean field variational Bayes and compute Bayesian FDR as follow:

fit_mfvb = sp_bgsmtr(X = sp_bgsmtr_example_data$SNP_data,
Y = sp_bgsmtr_example_data$BrainMeasures, method = "MFVB",
A = bgsmtr_example_data$neighborhood_structure, rho = 0.8,FDR_opt = TRUE,
lambdasq = 1000, iter_num = 10000.)

# MFVB estimated results for regression parameter W and estimated Bayesian FDR summaries
fit_mfvb$MFVB_summaries
fit_mfvb$FDR_summaries

# The corresponding lower bound of MFVB method after convergence is obtained as:
fit_mfvb$lower_boud

}


}
\author{
Yin Song, \email{yinsong@uvic.ca}

Shufei Ge \email{shufeig@sfu.ca}

Farouk S. Nathoo, \email{nathoo@uvic.ca}

Liangliang Wang \email{lwa68@sfu.ca}
}
