% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/histNetwork.R
\name{histNetwork}
\alias{histNetwork}
\title{Historical co-citation network}
\usage{
histNetwork(M, n = 10, sep = ";")
}
\arguments{
\item{M}{is a bibliographic data frame obtained by the converting function \code{\link{convert2df}}.
It is a data matrix with cases corresponding to manuscripts and variables to Field Tag in the original SCOPUS and Thomson Reuters' ISI Web of Knowledge file.}

\item{n}{is an integer, indicating the number of most cited references to select. Default value is 10.\cr}

\item{sep}{is the field separator character. This character separates strings in CR column of the data frame. The default is \code{sep = ";"}.}
}
\value{
\code{histAnalysis} returns an object of \code{class} "list" containing the following components:

\tabular{lll}{
NetMatrix \tab  \tab the historical co-citation network matrix\cr
Degree \tab       \tab the min degree of the network\cr
histData \tab      \tab the set of n most cited references}
}
\description{
\code{histNetwork} creates a historical co-citation network from a bibliographic data frame.
}
\examples{
data(scientometrics)

histResults <- histNetwork(scientometrics, n = 10, sep = ";")

library("igraph")

# Create igraph object
bsk.network <- graph.adjacency(histResults[[1]],mode = "directed")

# Remove loops
bsk.network <- simplify(bsk.network, remove.multiple = TRUE, remove.loops = TRUE) 

# Create the network layout (fixing vertical vertex coordinates by years)
l <- layout.fruchterman.reingold(bsk.network)
l[,2] <- histResults[[3]]$Year

# Plot the hystorical co-citation network
plot(bsk.network,layout = l, vertex.label.dist = 0.5, 
vertex.frame.color = 'blue', vertex.label.color = 'black', 
vertex.label.font = 1, vertex.label = V(bsk.network)$name, 
vertex.label.cex = 0.5,edge.arrow.size=0.1)


}
\seealso{
\code{\link{convert2df}} to import and convert an ISI or SCOPUS Export file in a bibliographic data frame.

\code{\link{summary}} to obtain a summary of the results.

\code{\link{plot}} to draw some useful plots of the results.

\code{\link{biblioNetwork}} to compute a bibliographic network.
}

