% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bdm_dMap.R
\name{bdm.dMap.plot}
\alias{bdm.dMap.plot}
\title{Class density maps plot.}
\usage{
bdm.dMap.plot(bdm, classes = NULL, join = FALSE, class.pltt = NULL,
  pakde.pltt = NULL, pakde.lvls = 16, wtt.lwd = 1, plot.peaks = T,
  labels.cex = 1, layer = 1)
}
\arguments{
\item{bdm}{A \var{bdm} instance as generated by \code{bdm.init()}.}

\item{classes}{A vector with a subset of class names or covariate values. Default value is \code{classes=NULL}. If no classes are specified (default value) all classes are plotted.}

\item{join}{Logical value. If FALSE (default value), class mapping is based on the class conditional distributions. If TRUE, class mapping is based on the overall classes join distribution.}

\item{class.pltt}{A palette of colours to identify the classes in the hard mapping. The length of the colour palette should be at least the number of classes plus one (the background colour being the first colour of the palette).}

\item{pakde.pltt}{A palette of colours to indicate the levels of the class density maps. The length of the colour palette should be at least the number of levels specified in \var{pakde.lvls}.}

\item{pakde.lvls}{The number of levels of the heat-map when plotting class density maps (16 by default).}

\item{wtt.lwd}{The width of the watertrack lines (as set in \code{par()}).}

\item{plot.peaks}{Logical value (TRUE by default). If set to TRUE and the up-stream step \code{bdm$wtt()} is computed the peak of each cluster is depicted.}

\item{labels.cex}{If \var{plot.peaks} is TRUE, the size of the labels of the clusters (as set in \code{par()}). By default \code{labels.cex=0.0} and the labels of the clusters are not depicted.}

\item{layer}{The number of the layer from which the class density maps are computed (1 by default).}
}
\value{
None.
}
\description{
Class density maps plot.
}
\details{
\code{bdm.dMap.plot()} yields a multi-plot layout where the first plot shows the dominating value of the covariate (or dominating class) in each cell, and the rest of the plots show the density map of each covariate value (or class).

The join distribution \eqn{P(V=v_{i},C=c_{j})} will be affected by the bias present in the marginal distribution of the covariate. Therefore, the join distribution \eqn{P(V=v_{i},C=c_{j})} is transformed, by default, into a conditional distribution \eqn{P(c_{j}|V=v_{i})} (where the \eqn{c_{j}} are the grid cells of the embedding and V is the covariate (or class)). Thus, the first plot shows a hard classification of grid-cells, (cells are coloured based on the dominating value of the covariate (or dominating class), \emph{i.e}. the \eqn{v_{i}} for which \eqn{P(c_{j}|V=v_{i})} is maximum), and the rest of the plots show the conditional distributions \eqn{P(C=c_{j}|V=v_{i})}. This makes the plots of the different classes not directly comparable but the dominant areas of each class can be more easily identified.

However, the same plots can be depicted based on the join distribution by setting \code{join = TRUE}. This makes sense when the bias in the covariate values (or classes) is not significant. In this case the hard clustering shows the real dominance of each covariate value (or class) over the embedding area and the density maps are comparable one to each other (although, individually, they are not real density functions as they do not add up to one).

The multi-plot layout can be limited to a subset of the values of the covariate (or subset of classes) specified in parameter \code{classes}.
}
\examples{

# --- load example dataset
bdm.example()
\dontrun{
exMap <- bdm.dMap(exMap, threads = 4)
bdm.dMap.plot(exMap)
}
}
