% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_hergm.R
\name{simulate_hergm_within}
\alias{simulate_hergm_within}
\title{Sample within cluster networks}
\usage{
simulate_hergm_within(
  formula_for_simulation,
  data_for_simulation,
  colname_vertex_id,
  colname_block_membership,
  coef_within_block,
  seed_edgelist = NULL,
  output = "stats",
  ergm_control = ergm::control.simulate.formula(),
  seed = NULL,
  n_sim = 1,
  verbose = 0,
  ...
)
}
\arguments{
\item{formula_for_simulation}{formula for simulating a network}

\item{data_for_simulation}{a data frame that contains vertex id, block membership, and vertex features.}

\item{colname_vertex_id}{a column name in the data frame for the vertex ids}

\item{colname_block_membership}{a column name in the data frame for the block membership}

\item{coef_within_block}{a vector of within-block parameters. The order of the parameters should match that of the formula.}

\item{seed_edgelist}{an edgelist used for creating a seed network. It should have the "edgelist" class}

\item{output}{The desired output of the simulation (any of \code{stats}, \code{network} or \code{edgelist}). Defaults to \code{stats}}

\item{ergm_control}{auxiliary function as user interface for fine-tuning ERGM simulation}

\item{seed}{seed value (integer) for network simulation.}

\item{n_sim}{number of networks generated}

\item{verbose}{If this is TRUE/1, the program will print out additional information about the progress of simulation.}

\item{...}{arguments to be passed to low level functions}
}
\value{
A 'data.frame' object where the columns relate to the sufficient statistics specified in \code{formula_for_simulation} and each row relates to one of the \code{n_sim} simulations.
}
\description{
Obtains network statistics based on MCMC simulations including only the within-blocks connections.
}
\examples{
data(toyNet) \donttest{
# Specify the model that you would like to estimate.
model_formula <- toyNet ~ edges + nodematch("x") + nodematch("y") 
# Estimate the model
nodes_data <- data.frame(
  node_id = 1:toyNet$gal$n,
  x = toyNet \%v\% "x",
  y = toyNet \%v\% "y",
  block = toyNet \%v\% "block"
)
list_feature_matrices <- 
   get_list_sparse_feature_adjmat(toyNet, model_formula)
toyNet <- network::as.edgelist(toyNet)

simulate_hergm_within(formula_for_simulation = model_formula, 
                      data_for_simulation = nodes_data,
                      colname_vertex_id = "node_id",
                      colname_block_membership = "block",
                      coef_within_block = c(-2,0.1,0.2),
                      n_sim = 10)
}
}
