% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_bigergm.R
\name{simulate_bigergm}
\alias{simulate_bigergm}
\title{Simulate networks under Exponential Random Graph Models (ERGMs) under local dependence}
\usage{
simulate_bigergm(
  formula,
  coef_within,
  coef_between,
  network = ergm.getnetwork(formula),
  control_within = ergm::control.simulate.formula(),
  only_within = FALSE,
  seed = NULL,
  nsim = 1,
  output = "network",
  verbose = 0,
  ...
)
}
\arguments{
\item{formula}{An \R \code{\link{formula}} object of the form
\code{y ~ <model terms>}, where \code{y} is a
\code{\link[network]{network}} object.
The network object must contain block information as a vertex attribute with the name 'block'.
For the details on the possible \code{<model terms>}, see
\code{\link[ergm]{ergmTerm}} and Morris, Handcock and Hunter (2008).
All terms that induce dependence are excluded from the between block model, while the within block model includes all terms.
The \code{\link[ergm.multi]{L-ergmTerm}} is supported to enable size-dependent coefficients for the within-blocks model.
Note, however, that for size-dependent parameters of terms that are included in the between-blocks model,
the intercept in the linear model provided to \code{\link[ergm.multi]{L-ergmTerm}} should not include the intercept.
See the second example of \code{\link{bigergm}} for a demonstration.}

\item{coef_within}{a vector of within-block parameters. The order of the parameters should match that of the formula.}

\item{coef_between}{a vector of between-block parameters. The order of the parameters should match that of the formula without externality terms.}

\item{network}{a network object to be used as a seed network for the simulation (if none is provided, the network on the lhs of the \code{formula} is used).}

\item{control_within}{auxiliary function as user interface for fine-tuning ERGM simulation for within-block networks.}

\item{only_within}{If this is TRUE, only within-block networks are simulated.}

\item{seed}{seed value (integer) for network simulation.}

\item{nsim}{number of networks generated.}

\item{output}{Normally character, one of "network" (default), "stats", "edgelist", to determine the output format.}

\item{verbose}{If this is TRUE/1, the program will print out additional information about the progress of simulation.}

\item{...}{Additional arguments, passed to \code{\link[ergm]{simulate_formula}}.}
}
\value{
Simulated networks, the output form depends on the parameter \code{output}
(default is a list of networks).
}
\description{
This function simulates networks under Exponential Random Graph Models (ERGMs) with local dependence.
There is also an option to simulate only within-block networks and a S3 method for the class \code{bigergm}.
}
\examples{
data(toyNet)
# Specify the model that you would like to estimate.
model_formula <- toyNet ~ edges + nodematch("x") + nodematch("y") + triangle
# Simulate network stats
sim_stats <- bigergm::simulate_bigergm(
formula = model_formula,
  # Formula for the model
coef_between = c(-4.5,0.8, 0.4),
# The coefficients for the between connections
coef_within = c(-1.7,0.5,0.6,0.15),
# The coefficients for the within connections
nsim = 10,
# Number of simulations to return
output = "stats",
# Type of output
)

}
\references{
Morris M, Handcock MS, Hunter DR (2008). Specification of Exponential-Family Random Graph Models: Terms and Computational Aspects.
Journal of Statistical Software, 24.
}
