% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bigleaf_physiology.r
\name{light.use.efficiency}
\alias{light.use.efficiency}
\title{Light Use Efficiency (LUE)}
\usage{
light.use.efficiency(GPP, PPFD)
}
\arguments{
\item{GPP}{Gross ecosystem productivity (umol CO2 m-2 s-1)}

\item{PPFD}{Photosynthetic photon flux density (umol quanta m-2 s-1)}
}
\value{
\item{LUE -}{Light use efficiency (-)}
}
\description{
Amount of carbon fixed (GPP) per incoming light.
}
\details{
Light use efficiency is calculated as
         
            \deqn{LUE = sum(GPP)/sum(PPFD)}
         
         where both GPP and PPFD are in umol m-2 s-1. A more meaningful 
         (as directly comparable across ecosystems) approach is to take 
         absorbed PPFD rather than incoming PPFD as used here.
}
\examples{
light.use.efficiency(GPP=20,PPFD=1500)

}
\seealso{
\code{\link{energy.use.efficiency}}
}
