% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{big_fread2}
\alias{big_fread2}
\title{Read large text file}
\usage{
big_fread2(file, nb_parts = NULL, .transform = identity,
  .combine = cbind_df, skip = 0, select = NULL, progress = FALSE,
  part_size = 500 * 1024^2, ...)
}
\arguments{
\item{file}{Path to file that you want to read.}

\item{nb_parts}{Number of parts in which to split reading (and transforming).
Parts are referring to blocks of selected columns.
Default uses \code{part_size} to set a good value.}

\item{.transform}{Function to transform each data frame corresponding to each
block of selected columns. Default doesn't change anything.}

\item{.combine}{Function to combine results (list of data frames).}

\item{skip}{Number of lines to skip at the beginning of \code{file}.}

\item{select}{Indices of columns to keep (sorted). Default keeps them all.}

\item{progress}{Show progress? Default is \code{FALSE}.}

\item{part_size}{Size of the parts if \code{nb_parts} is not supplied.
Default is \code{500 * 1024^2} (500 MB).}

\item{...}{Other arguments to be passed to \link[data.table:fread]{data.table::fread},
excepted \code{input}, \code{file}, \code{skip}, \code{select} and \code{showProgress}.}
}
\value{
The outputs of \code{fread2} + \code{.transform}, combined with \code{.combine}.
}
\description{
Read large text file by splitting columns.
}
