% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bq-projects.R
\name{bq_projects}
\alias{bq_projects}
\title{List available projects}
\usage{
bq_projects(page_size = 100, max_pages = 1, warn = TRUE)
}
\arguments{
\item{page_size}{Number of items per page.}

\item{max_pages}{Maximum number of pages to retrieve. Use \code{Inf} to retrieve
all pages (this may take a long time!)}

\item{warn}{If \code{TRUE}, warn when there are unretrieved pages.}
}
\value{
A character vector.
}
\description{
List all projects that you have access to. You can also work with
\href{https://cloud.google.com/bigquery/public-data/}{public datasets},
but you will need to provide a \code{billing} project whenever you perform
any non-free operation.
}
\section{Google BigQuery API documentation}{

\itemize{
\item \href{https://cloud.google.com/bigquery/docs/reference/rest/v2/projects/list}{list}
}
}

\examples{
\dontshow{if (bq_testable()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
bq_projects()
\dontshow{\}) # examplesIf}
}
