% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{distributions_setup}
\alias{distributions_setup}
\title{Setup Distributions.jl}
\usage{
distributions_setup()
}
\value{
Return the imported wrapper of Distributions.jl Julia package
}
\description{
This function initializes the Distributions package that many of the bigsimr
functions work with.
}
\examples{
\donttest{
library(bigsimr)
bs   <- bigsimr::bigsimr_setup()
dist <- bigsimr::distributions_setup()

JuliaCall::julia_eval('using Random; Random.seed!(1);')
# Generate random target correlation matrix
target_corr <- bs$cor_randPD(3)
# Set the margins of variables
margins <- c(dist$Binomial(20, 0.2), dist$Beta(2, 3), dist$LogNormal(3, 1))
# Adjust target correlation matrix using Pearson matching
adjusted_corr <- bs$pearson_match(target_corr, margins)
# Generate random vectors
x <- bs$rvec(10000, adjusted_corr, margins)
}
}
