% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-save-infos.R
\name{snp_save}
\alias{snp_save}
\title{Save modifications}
\usage{
snp_save(x, version = NULL)
}
\arguments{
\item{x}{A \link[=bigSNP-class]{bigSNP}.}

\item{version}{the workspace format version to use.  \code{NULL}
    specifies the current default version (3). The only other supported
    value is 2, the default from \R 1.4.0 to \R 3.5.0.}
}
\value{
The (saved) \code{bigSNP}.
}
\description{
Save a \code{bigSNP} after having made some modifications to it.
As \code{bigSNP} is an S3 class, you can add any slot you want
to an object of this class, then use \code{snp_save} to
save these modifications in the corresponding ".rds" backing file.
}
\examples{
set.seed(1)

# Reading example
test <- snp_attachExtdata()

# I can add whatever I want to an S3 class
test$map$`p-values` <- runif(nrow(test$map))
str(test$map)

# Reading again
rds <- test$genotypes$rds
test2 <- snp_attach(rds)
str(test2$map) # new slot wasn't saved

# Save it
snp_save(test)

# Reading again
test3 <- snp_attach(rds)
str(test3$map) # it is saved now

# The complicated code of this function
snp_save
}
