% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spmat-accessor.R
\name{[,SFBM,ANY,ANY,ANY-method}
\alias{[,SFBM,ANY,ANY,ANY-method}
\alias{[,SFBM_compact,ANY,ANY,ANY-method}
\title{Accessor methods for class \code{SFBM}.}
\usage{
\S4method{[}{SFBM,ANY,ANY,ANY}(x, i, j, ..., drop = FALSE)

\S4method{[}{SFBM_compact,ANY,ANY,ANY}(x, i, j, ..., drop = FALSE)
}
\arguments{
\item{x}{A \link[=SFBM-class]{SFBM} object.}

\item{i}{A vector of indices (or nothing). You can use positive and negative
indices, and also logical indices (that are recycled).}

\item{j}{A vector of indices (or nothing). You can use positive and negative
indices, and also logical indices (that are recycled).}

\item{...}{Not used. Just to make \link{nargs} work.}

\item{drop}{Not implemented; always return a sparse matrix (\code{drop = FALSE}).}
}
\description{
Accessor methods for class \code{SFBM}.
}
\examples{
spmat <- Matrix::Diagonal(4, 0:3)
spmat[4, 2] <- 5
spmat[1, 4] <- 6
spmat[3, 4] <- 7
spmat

X <- as_SFBM(spmat)
X[1:3, 2:3]
X[, 4]   # parameter drop is not implemented
X[-1, 3:4]

X2 <- as_SFBM(spmat, compact = TRUE)
X2[1:3, 2:3]

}
