% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transpose.R
\name{big_transpose}
\alias{big_transpose}
\title{Transpose an FBM}
\usage{
big_transpose(X, backingfile = tempfile(tmpdir = getOption("FBM.dir")))
}
\arguments{
\item{X}{An object of class \link[=FBM-class]{FBM}.}

\item{backingfile}{Path to the file storing the Big Matrix on disk.
\strong{An extension ".bk" will be automatically added.}
Default stores in the temporary directory.}
}
\value{
The new transposed FBM. Dimensions and type are automatically
determined from the input FBM.
}
\description{
This function implements a simple cache-oblivious algorithm for
the transposition of a Filebacked Big Matrix.
}
\examples{
X <- FBM(6, 5, init = rnorm(30))
X[]
Xt <- big_transpose(X)
identical(t(X[]), Xt[])

}
