% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distmat.R
\name{bike_distmat}
\alias{bike_distmat}
\title{Extract station-to-station distance matrix}
\usage{
bike_distmat(bikedb, city, expand = 0.5, long = FALSE, quiet = TRUE)
}
\arguments{
\item{bikedb}{A string containing the path to the SQLite3 database.
If no directory specified, it is presumed to be in \code{tempdir()}.}

\item{city}{City for which tripmat is to be aggregated}

\item{expand}{Distances are calculated by routing through the OpenStreetMap
street network surrounding the bike stations, with the street network
expanded by this amount to ensure all stations can be connected.}

\item{long}{If FALSE, a square distance matrix of (num-stations,
num_stations) is returned; if TRUE, a long-format matrix of (stn-from,
stn-to, distance) is returned.}

\item{quiet}{If FALSE, progress is displayed on screen}
}
\value{
If \code{long = FALSE}, a square matrix of numbers of trips between
each station, otherwise a long-form \pkg{tibble} with three columns of of
(start_station_id, end_station_id, distance)
}
\description{
Extract station-to-station distance matrix
}
\note{
Distance matrices returned from \code{bike_distamat} use all stations
listed for a given system, while trip matrices extracted with
\link{bike_tripmat} will often have fewer stations because operational
station numbers commonly vary over time. The two matrices may be reconciled
with the \code{match_trips2dists} function, enabling then to be directly
compared.
}
