% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/billboard-mapping.R
\name{billboard-aes}
\alias{billboard-aes}
\alias{bb_aes}
\alias{bb_aes_string}
\alias{bbaes}
\alias{bbaes_string}
\title{Map variables on the chart}
\usage{
bb_aes(bb, ...)

bb_aes_string(bb, ...)

bbaes(...)

bbaes_string(...)
}
\arguments{
\item{bb}{A \code{billboard} \code{htmlwidget} object.}

\item{...}{Mapping parameters, such as \code{x} for x-axis, \code{y} for y-axis, \code{group} for grouping variable.}
}
\value{
A \code{billboard} \code{htmlwidget} object.
}
\description{
Map variables on the chart
}
\note{
\code{bb_aes} is intended to use in a "piping" way. 
\code{bbaes} is the equivalent to use inside a helper function
 such as \code{bb_barchart}, \code{bb_scatterplot}...
}
\examples{
\dontrun{
dat <- as.data.frame(table(sample(letters[1:5], 100, TRUE)))

billboarder(data = dat) \%>\% 
  bb_aes(x = Var1, y = Freq) \%>\% 
  bb_barchart()


tab <- table(sample(letters[1:5], 100, TRUE), sample(LETTERS[1:5], 100, TRUE))
dat_group <- as.data.frame(tab)

billboarder(data = dat_group) \%>\% 
  bb_aes(x = Var1, y = Freq, group = "Var2") \%>\% 
  bb_barchart()
}
}
