% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opCharMethodFunctions.R
\name{CompareConfig}
\alias{CompareConfig}
\title{Compare group testing results}
\usage{
CompareConfig(object1, object2)
}
\arguments{
\item{object1}{An object of class "opChar" containing group testing results.}

\item{object2}{A second object of class "opChar" containing group
testing results.}
}
\value{
A data frame with the expected percent reduction in tests (PercentReductionTests) and the expected
increase in testing capacity (PercentIncreaseTestCap) when using the second testing configuration rather than
the first testing configuration. Positive values for these quantities
indicate that the second testing configuration is more efficient than the first.
}
\description{
Compare group testing results from objects of class
"opchar" returned by \code{\link{operatingCharacteristics1}} (\kbd{opChar1})
or \code{\link{operatingCharacteristics2}} (\kbd{opChar2}).
}
\details{
The \code{CompareConfig} function compares group testing results from
two objects of class "opChar". The function creates a
data frame with these comparisons.
}
\examples{
config.mat1 <- matrix(data = c(rep(1, 10), rep(1:2, each = 5), 1:10),
                      nrow = 3, ncol = 10, byrow = TRUE)
res1 <- opChar1(algorithm = "D3", p = 0.05, Se = 0.99, Sp = 0.99,
                hier.config = config.mat1)
config.mat2 <- matrix(data = c(rep(1, 10), 1:10),
                      nrow = 2, ncol = 10, byrow = TRUE)
res2 <- opChar1(algorithm = "D2", p = 0.05, Se = 0.99, Sp = 0.99,
        hier.config = config.mat2)
CompareConfig(res2, res1)

config.mat3 <- matrix(data = c(rep(1, 10), rep(1, 5),
                               rep(2, 4), 3, 1:9, NA),
                      nrow = 3, ncol = 10, byrow = TRUE)
Se <- matrix(data = rep(0.95, 6), nrow = 2, ncol = 3,
             dimnames = list(Infection = 1:2, Stage = 1:3))
Sp <- matrix(data = rep(0.99, 6), nrow = 2, ncol = 3,
             dimnames = list(Infection = 1:2, Stage = 1:3))
res3 <- opChar2(algorithm = "D3", p.vec = c(0.95, 0.02, 0.02, 0.01),
                Se = Se, Sp = Sp, hier.config = config.mat3)
config.mat4 <- matrix(data = c(rep(1, 12), rep(1, 6), rep(2, 6),
                               rep(1, 4), rep(2, 2), rep(3, 3),
                               rep(4, 3), 1:12),
                    nrow = 4, ncol = 12, byrow = TRUE)
Se <- matrix(data = rep(0.95, 8), nrow = 2, ncol = 4,
             dimnames = list(Infection = 1:2, Stage = 1:4))
Sp <- matrix(data = rep(0.99, 8), nrow = 2, ncol = 4,
             dimnames = list(Infection = 1:2, Stage = 1:4))
res4 <- opChar2(algorithm = "D4", p.vec = c(0.92, 0.05, 0.02, 0.01),
                Se = Se, Sp = Sp, hier.config = config.mat4)
CompareConfig(res4, res3)
}
\author{
Brianna D. Hitt and Christopher R. Bilder
}
