% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/func_logl.R
\name{func_logl}
\alias{func_logl}
\title{Function: Loss Function}
\usage{
func_logl(
  i,
  L_freq,
  R_freq,
  L_pick,
  R_pick,
  L_value,
  R_value,
  L_dir,
  R_dir,
  L_prob,
  R_prob,
  var1 = NA,
  var2 = NA,
  LR,
  try,
  value,
  utility,
  reward,
  occurrence,
  alpha,
  beta
)
}
\arguments{
\item{i}{The current row number.}

\item{L_freq}{The frequency of left option appearance}

\item{R_freq}{The frequency of right option appearance}

\item{L_pick}{The number of times left option was picked}

\item{R_pick}{The number of times left option was picked}

\item{L_value}{The value of the left option}

\item{R_value}{The value of the right option}

\item{L_dir}{Whether the participant chose the left option.}

\item{R_dir}{Whether the participant chose the right option.}

\item{L_prob}{The probability that the model assigns to choosing the left option.}

\item{R_prob}{The probability that the model assigns to choosing the left option.}

\item{var1}{[character] 
Column name of extra variable 1. If your model uses more than just reward 
 and expected value, and you need other information, such as whether the 
 choice frame is Gain or Loss, then you can input the 'Frame' column as 
 var1 into the model.
 
 \code{default: var1 = "Extra_Var1"}}

\item{var2}{[character] 
Column name of extra variable 2. If one additional variable, var1, does not 
 meet your needs, you can add another additional variable, var2, into your 
 model.
 
 \code{default: var2 = "Extra_Var2"}}

\item{LR}{Are you calculating the probability for the left option or the right option?}

\item{try}{If the choice was random, the value is 1; 
If the choice was based on value, the value is 0.}

\item{value}{The expected value of the stimulus in the subject's mind at this point in time.}

\item{utility}{The subjective value that the subject assigns to the objective reward.}

\item{reward}{The objective reward received by the subject after selecting a stimulus.}

\item{occurrence}{The number of times the same stimulus has been chosen.}

\item{alpha}{[vector]
Extra parameters that may be used in functions.}

\item{beta}{[vector]
Extra parameters that may be used in functions.}
}
\value{
log-likelihood
}
\description{
This loss function reflects the similarity between human choices
 and RL model predictions. If a human selects the left option and the
 RL model predicts a high probability for the left option, then 
 \eqn{logP_{L}} approaches 0, causing the first term to approach 0.

Since the human chose the left option, \eqn{B_{R}} becomes 0, making the 
 second term naturally zero. Therefore, the more consistent the RL model's 
 prediction is with human choice, the closer this LL value is to 0. 
 Conversely, it approaches negative infinity.
 \deqn{
   LL = \sum B_{L} \times \log P_{L} + \sum B_{R} \times \log P_{R}
 }
}
\note{
When customizing these functions, please ensure that you do not modify 
 the arguments. Instead, only modify the \code{if-else} statements or 
 the internal logic to adapt the function to your needs.
}
\examples{
\dontrun{
func_logl <- function(
  # Trial number
  i,
  # Number of times this option has appeared
  L_freq,
  R_freq,
  # Number of times this option has been chosen
  L_pick,
  R_pick,
  # Current value of this option
  L_value,
  R_value,
  # 
  L_dir,
  R_dir,
  #
  L_prob,
  R_prob,
  # Extra variables
  var1 = NA,
  var2 = NA,

  # Whether calculating probability for left or right choice
  LR,
  # Is it a random choosing trial?
  try,

  # Extra parameters
  alpha,
  beta
){
  logl <- switch(
    EXPR = LR,
    "L" = L_dir * log(L_prob),
    "R" = R_dir * log(R_prob)
  )
}
}

}
