% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binomialRF.R
\name{binomialRF}
\alias{binomialRF}
\title{random forest feature selection based on binomial exact test}
\usage{
binomialRF(X,y, fdr.threshold = .05,fdr.method = 'BY',
                      ntrees = 2000, percent_features = .5,
                      keep.both=FALSE, user_cbinom_dist=NULL,
                      sampsize=round(nrow(X)*.63))
}
\arguments{
\item{X}{design matrix}

\item{y}{class label}

\item{fdr.threshold}{fdr.threshold for determining which set of features are significant}

\item{fdr.method}{how should we adjust for multiple comparisons (i.e., \code{p.adjust.methods} =c("holm", "hochberg", "hommel", "bonferroni", "BH", "BY","fdr", "none"))}

\item{ntrees}{how many trees should be used to grow the \code{randomForest}?}

\item{percent_features}{what percentage of L do we subsample at each tree? Should be a proportion between (0,1)}

\item{keep.both}{should we keep the naive binomialRF as well as the correlated adjustment}

\item{user_cbinom_dist}{insert either a pre-specified correlated binomial distribution or calculate one via the R package \code{correlbinom}.}

\item{sampsize}{how many samples should be included in each tree in the randomForest}
}
\value{
a data.frame with 4 columns: Feature Name, Frequency Selected, Probability of Selecting it randomly, Adjusted P-value based on \code{fdr.method}
}
\description{
\code{binomialRF} is the R implementation of the feature selection algorithm by (Zaim 2019)
}
\examples{
set.seed(324)

###############################
### Generate simulation data
###############################

X = matrix(rnorm(1000), ncol=10)
trueBeta= c(rep(10,5), rep(0,5))
z = 1 + X \%*\% trueBeta
pr = 1/(1+exp(-z))
y = as.factor(rbinom(100,1,pr))

###############################
### Run binomialRF
###############################

binom.rf <-binomialRF(X,y, fdr.threshold = .05,fdr.method = 'BY',
                      ntrees = 2000,percent_features = .5,
                      keep.both=FALSE, user_cbinom_dist=NULL,
                      sampsize=round(nrow(X)*.63))

print(binom.rf)
}
\references{
Zaim, SZ; Kenost, C.; Lussier, YA; Zhang, HH. binomialRF: Scalable Feature Selection and Screening for Random Forests to Identify Biomarkers and Their Interactions, bioRxiv, 2019.
}
