% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estgtpr.R
\name{estgtpr}
\alias{estgtpr}
\title{Results for Bayesian MCMC estimation of parameters of generalized Thomas process}
\usage{
estgtpr(est, discard = 100, step = 10)
}
\arguments{
\item{est}{Output from \code{\link[=estgtp]{estgtp()}} function.}

\item{discard}{Number of iterations to be discarded as burn in for the estimation.}

\item{step}{Every \emph{step} iteration is taken in the parameter estimation.}
}
\value{
Median and quantile values and plots (\emph{kappa}, \emph{omega}, \emph{lambda}, \emph{theta}).
}
\description{
Calculates median values for \emph{kappa}, \emph{omega}, \emph{lambda}, \emph{theta}; calculates 2.5 and 97.5 quantile and draws trace plots.
}
\examples{

library(spatstat)
kappa = 10
omega = .1
lambda= .5
theta = 10

X = rgtp(kappa, omega, lambda, theta, win = owin(c(0, 1), c(0, 1)))
plot(X$X)
plot(X$C)

a_kappa = 4
b_kappa = 1
x <- seq(0, 100, length = 100)
hx <- dlnorm(x, a_kappa, b_kappa)
plot(x, hx, type = "l", lty = 1, xlab = "x value",
     ylab = "Density", main = "Prior")

a_omega = -3
b_omega = 1
x <- seq(0, 1, length = 100)
hx <- dlnorm(x, a_omega, b_omega)
plot(x, hx, type = "l", lty = 1, xlab = "x value",
     ylab = "Density", main = "Prior")

l_lambda = -1
u_lambda = 0.99
x <- seq(-1, 1, length = 100)

hx <- dunif(x, l_lambda, u_lambda)
plot(x, hx, type = "l", lty = 1, xlab = "x value",
     ylab = "Density", main = "Prior")

a_theta = 4
b_theta = 1
x <- seq(0, 100, length = 100)
hx <- dlnorm(x, a_theta, b_theta)
plot(x, hx, type = "l", lty = 1, xlab = "x value",
     ylab = "Density", main = "Prior")

est = estgtp(X$X,
          skappa = exp(a_kappa + ((b_kappa ^ 2) / 2)) / 100,
          somega = exp(a_omega + ((b_omega ^ 2) / 2)) / 100,
          dlambda = 0.01,
          stheta = exp(a_theta + ((b_theta ^ 2) / 2)) / 100, smove = 0.1,
          a_kappa = a_kappa, b_kappa = b_kappa,
          a_omega = a_omega, b_omega = b_omega,
          l_lambda = l_lambda, u_lambda = u_lambda,
          a_theta = a_theta, b_theta = b_theta,
          iter = 50, plot.step = 50, save.step = 1e9,
          filename = "")

discard = 10
step = 10

result = estgtpr(est, discard, step)

}
