% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_vpts.R
\name{read_vpts}
\alias{read_vpts}
\title{Read a time series of vertical profiles (\code{vpts}) from file}
\usage{
read_vpts(file, radar, lat, lon, height, wavelength = "C")
}
\arguments{
\item{file}{A text file containing the standard output (stdout) generated
by vol2bird (or the package function \code{calculate_vp}).}

\item{radar}{A string containing a radar identifier.}

\item{lat}{numeric. Latitude of the radar in decimal degrees.}

\item{lon}{numeric. Longitude of the radar in decimal degrees.}

\item{height}{numeric. Height above sea level of the radar antenna in meters.}

\item{wavelength}{Radar wavelength in cm, or one of 'C' or 'S' for C-band
and S-band radar, respectively, in which case C-band wavelength is assumed
to be 5.3 cm and S-band wavelength 10.6 cm}
}
\value{
An object inheriting from class \code{vpts}, see
\code{\link[=summary.vpts]{vpts}} for details.
}
\description{
Read a time series of vertical profiles (\code{vpts}) from file
}
\examples{
# locate example file:
vptsfile <- system.file("extdata", "example_vpts.txt", package = "bioRad")
# load time series:
ts <- read_vpts(vptsfile, radar = "KBGM", wavelength = "S")
ts
}
