% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bioacoustics.R
\docType{package}
\name{bioacoustics-package}
\alias{bioacoustics}
\alias{bioacoustics-package}
\title{bioacoustics: detect and extract automatically acoustic features in Zero-Crossing files and audio recordings}
\description{
bioacoustics contains all the necessary functions to read Zero-Crossing files and audio recordings of various formats,
filter noisy files, display audio signals, detect and extract automatically acoustic features
for further analysis such as species identification based on classification of animal vocalizations.
}
\details{
bioacoustics is subdivided into three main components:

\itemize{
\item Read, extract data (not yet implemented), display, and write Zero-Crossing files.
\item Stand-alone tools to display, convert or resample MP3, WAV, and WAC files.
\item Read MP3, WAV or WAC files, filter, and extract automatically acoustic features.
}

To learn more about bioacoustics, start with the vignette:
`browseVignettes(package = "bioacoustics")`
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/wavx/bioacoustics/}
  \item Report bugs at \url{https://github.com/wavx/bioacoustics/issues/}
}

}
\author{
\strong{Maintainer}: Jean Marchal \email{jean.marchal@wavx.ca}

Authors:
\itemize{
  \item Francois Fabianek \email{francois.fabianek@wavx.ca}
  \item Christopher Scott
}

Other contributors:
\itemize{
  \item Chris Corben \email{chris@hoarybat.com} (Read ZC files, original C code) [contributor, copyright holder]
  \item Peter Wilson \email{peter@peterwilson.id.au} (Read ZC files, original R code) [contributor, copyright holder]
  \item  Wildlife Acoustics, Inc. (Read WAC files, original C code) [contributor, copyright holder]
  \item  WavX Inc. [copyright holder]
}

}
