\name{EPE}
\encoding{UTF-8}
\alias{EPE}
\title{
Calculation of the Ordinate For an Arbitrary Point on the Explicit Preston Curve in the Plane  
}
\description{
\code{EPE} is used to calculate the \emph{y}-value for an arbitrary point on the Preston curve 
that was generated by the explicit Preston equation or one of its simplified versions for a given \emph{x}-value.
}
\usage{
EPE(P, x, simpver = NULL)
}
\arguments{
  \item{P}{the parameters of the Preston equation or one of its simplified versions.}
  \item{x}{the \emph{x}-value used in the explicit Preston equation.}
  \item{simpver}{an optional argument to use the simplified version of the explicit Preston equation.}
}
\details{
When \code{simpver = NULL}, the explicit Preston equation is selected: 
\deqn{ y = b\ \sqrt{1-\left(\frac{x}{a}\right)^2}\left(1+c_{1}\ \frac{x}{a}+c_{2}\left(\frac{x}{a}\right)^2+c_{3}\left(\frac{x}{a}\right)^3\right) }
where \code{P} has five parameters: \eqn{a}, \eqn{b}, \eqn{c_{1}}, \eqn{c_{2}}, and \eqn{c_{3}}.

\eqn{\quad} When \code{simpver = 1}, the simplified version 1 is selected:
\deqn{ y = b\ \sqrt{1-\left(\frac{x}{a}\right)^2}\left(1+c_{1}\ \frac{x}{a}+c_{2}\left(\frac{x}{a}\right)^2\right) }
where \code{P} has four parameters: \eqn{a}, \eqn{b}, \eqn{c_{1}}, and \eqn{c_{2}}.

\eqn{\quad} When \code{simpver = 2}, the simplified version 2 is selected:
\deqn{ y = b\ \sqrt{1-\left(\frac{x}{a}\right)^2}\left(1+c_{1}\ \frac{x}{a}\right) }
where \code{P} has three parameters: \eqn{a}, \eqn{b}, and \eqn{c_{1}}.

\eqn{\quad} When \code{simpver = 3}, the simplified version 3 is selected:
\deqn{ y = b\ \sqrt{1-\left(\frac{x}{a}\right)^2}\left(1+c_{2}\left(\frac{x}{a}\right)^2\right) }
where \code{P} has three parameters: \eqn{a}, \eqn{b}, and \eqn{c_{2}}.
}
\note{
We only considered the upper part of the egg-shape curve in the above expressions because 
the lower part is symmetrical to the upper part around the \emph{x}-axis.  
The egg length axis in \code{\link{EPE}} overlaps 
the \emph{x}-axis, while the egg length axis in \code{\link{PE}} overlaps the \emph{y}-axis. 
The \code{\link{EPE}} function has the same parameters, \code{P}, as those in the 
\code{\link{PE}} function. 
The explicit Preston equation is used for calculating an egg's volume and surface area, 
when the parameters, \code{P}, are obtained using the \code{\link{fitPE}} function 
or the \code{\link{lmPE}} function based on the \code{\link{PE}} function. 
However, it cannot be used by the \code{\link{fitPE}} function or the \code{\link{lmPE}} function 
in fitting the egg boundary data to estimate the parameters of the Preston equation.
}
\author{
Peijian Shi \email{pjshi@njfu.edu.cn}, Johan Gielis \email{johan.gielis@uantwerpen.be}, 
Brady K. Quinn \email{Brady.Quinn@dfo-mpo.gc.ca}.
}
\references{
A manuscript for \emph{Annals of the New York Academy of Sciences} is 
currently under preparation by Shi et al.
}
\seealso{
\code{\link{PE}}, \code{\link{SurfaceAreaPE}}, \code{\link{VolumePE}}
}
\examples{
  Par3 <- c(4.27, 2.90, 0.0868, 0.0224, -0.0287)
  x    <- seq(-4.27, 4.27, by=0.001)
  y1   <- EPE(P=Par3, x=x, simpver=NULL)
  y2   <- -EPE(P=Par3, x=x, simpver=NULL)

  dev.new()
  plot(x, y1, asp=1, type="l", col=4, cex.lab=1.5, cex.axis=1.5,
       xlim=c(-5, 5), ylim=c(-5, 5), 
       xlab=expression(italic(x)), ylab=expression(italic(y)))
  lines(x, y2, col=2)  
}