% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/position_ngrams.R
\name{position_ngrams}
\alias{position_ngrams}
\title{Position n-grams}
\usage{
position_ngrams(ngrams, df = FALSE, unigrams_output = TRUE)
}
\arguments{
\item{ngrams}{a vector of positioned n-grams (as created by \code{\link{count_ngrams}}).}

\item{df}{logical, if \code{TRUE} returns a data frame, if \code{FALSE} returns a list.}

\item{unigrams_output}{logical, if \code{TRUE} extracts unigrams from the data and returns
information about their position.}
}
\value{
if \code{df} is \code{FALSE}, returns a list of length equal to the number of unique
n-gram starts present in n-grams. Each element of the list contains n-grams that start on
this position. If \code{df} is \code{FALSE}, returns a data frame where first column contains
n-grams and the second column represent their start positions.
}
\description{
Tranforms a vector of positioned n-grams into a list of positions filled with n-grams
that start on them.
}
\examples{
#position data in the list format
position_ngrams(c("2_1.1.2_0.1", "3_1.1.2_0.0", "3_2.2.2_0.0"))
#position data in the data frame format
position_ngrams(c("2_1.1.2_0.1", "3_1.1.2_0.0", "3_2.2.2_0.0"), df = TRUE)
}
\seealso{
Transform n-gram name to human-friendly form: \code{\link{decode_ngrams}}.

Validate n-gram structure: \code{\link{is_ngram}}.
}

